/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.config;

import jakarta.faces.context.FacesContext;
import jakarta.validation.Validation;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.util.LangUtils;

public class PrimeEnvironment {
    private static final Logger LOGGER = Logger.getLogger(PrimeEnvironment.class.getName());
    private final boolean beanValidationAvailable;
    private final boolean atLeastEl22 = LangUtils.tryToLoadClassForName("jakarta.el.ValueReference") != null;
    private final boolean atLeastJsf40 = LangUtils.tryToLoadClassForName("jakarta.faces.lifecycle.ClientWindowScoped") != null;
    private final boolean atLeastJsf23 = LangUtils.tryToLoadClassForName("jakarta.faces.component.UIImportConstants") != null;
    private final boolean atLeastJsf22 = LangUtils.tryToLoadClassForName("jakarta.faces.flow.Flow") != null;
    private final boolean atLeastJsf21 = LangUtils.tryToLoadClassForName("jakarta.faces.component.TransientStateHolder") != null;
    private final boolean mojarra;
    private final boolean atLeastBv11 = LangUtils.tryToLoadClassForName("jakarta.validation.executable.ExecutableValidator") != null;
    private final boolean atLeastServlet30 = LangUtils.tryToLoadClassForName("jakarta.servlet.SessionCookieConfig") != null;
    private final String buildVersion;
    private final boolean htmlSanitizerAvailable;

    public PrimeEnvironment(FacesContext context) {
        this.beanValidationAvailable = this.resolveBeanValidationAvailable();
        this.buildVersion = this.resolveBuildVersion();
        this.htmlSanitizerAvailable = LangUtils.tryToLoadClassForName("org.owasp.html.PolicyFactory") != null;
        this.mojarra = context == null || context.getExternalContext() == null ? false : context.getExternalContext().getApplicationMap().containsKey("com.sun.faces.ApplicationAssociate");
    }

    protected boolean resolveBeanValidationAvailable() {
        boolean beanValidationAvailable;
        boolean bl = beanValidationAvailable = LangUtils.tryToLoadClassForName("jakarta.validation.Validation") != null;
        if (beanValidationAvailable) {
            try {
                Validation.buildDefaultValidatorFactory().getValidator();
            }
            catch (Throwable t) {
                LOGGER.log(Level.FINE, "BV not available - Could not build default ValidatorFactory.");
                beanValidationAvailable = false;
            }
        }
        return beanValidationAvailable;
    }

    protected String resolveBuildVersion() {
        String buildVersion = null;
        try (InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.primefaces/primefaces/pom.properties");){
            Properties buildProperties = new Properties();
            buildProperties.load(is);
            buildVersion = buildProperties.getProperty("version");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PrimeFaces version not resolvable - Could not load pom.properties.");
        }
        if (LangUtils.isBlank(buildVersion)) {
            buildVersion = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
        }
        return buildVersion;
    }

    public boolean isBeanValidationAvailable() {
        return this.beanValidationAvailable;
    }

    public boolean isAtLeastEl22() {
        return this.atLeastEl22;
    }

    public boolean isAtLeastJsf40() {
        return this.atLeastJsf40;
    }

    public boolean isAtLeastJsf23() {
        return this.atLeastJsf23;
    }

    public boolean isAtLeastJsf22() {
        return this.atLeastJsf22;
    }

    public boolean isAtLeastJsf21() {
        return this.atLeastJsf21;
    }

    public boolean isAtLeastServlet30() {
        return this.atLeastServlet30;
    }

    public boolean isMojarra() {
        return this.mojarra;
    }

    public boolean isAtLeastBv11() {
        return this.atLeastBv11;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public boolean isHtmlSanitizerAvailable() {
        return this.htmlSanitizerAvailable;
    }
}

