/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.ConverterException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.primefaces.component.datepicker.DatePicker;
import org.primefaces.convert.ClientConverter;
import org.primefaces.util.CalendarUtils;

public class DateTimeConverter
extends jakarta.faces.convert.DateTimeConverter
implements ClientConverter {
    private Map<String, Object> metadata;

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (component instanceof DatePicker) {
            return this.getAsObject(context, (DatePicker)component, value);
        }
        return super.getAsObject(context, component, value);
    }

    public Object getAsObject(FacesContext context, DatePicker datePicker, String value) {
        if (value == null) {
            return null;
        }
        String type = this.getType();
        boolean isDate = "date".equals(type);
        boolean isLocalDateTime = "localDateTime".equals(type);
        if (isDate || isLocalDateTime) {
            try {
                DateTimeFormatter formatter = this.getDateTimeFormatter(context, datePicker);
                LocalTime time = datePicker.isShowTime() ? LocalTime.parse(value, formatter) : LocalTime.MIDNIGHT;
                ZoneId zone = CalendarUtils.calculateZoneId(datePicker.getTimeZone());
                LocalDateTime localDateTime = LocalDate.parse(value, formatter).atTime(time).atZone(zone).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                if (isDate) {
                    return CalendarUtils.convertLocalDateTime2Date(localDateTime);
                }
                return localDateTime;
            }
            catch (Exception ex) {
                throw new ConverterException(ex.getMessage(), (Throwable)ex);
            }
        }
        return super.getAsObject(context, (UIComponent)datePicker, value);
    }

    protected DateTimeFormatter getDateTimeFormatter(FacesContext context, DatePicker datePicker) {
        String pattern = datePicker.calculatePattern();
        Locale locale = datePicker.calculateLocale(context);
        return DateTimeFormatter.ofPattern(pattern, locale);
    }

    @Override
    public Map<String, Object> getMetadata() {
        if (this.metadata == null) {
            String pattern = this.getPattern();
            String type = this.getType();
            String dateStyle = this.getDateStyle();
            String timeStyle = this.getTimeStyle();
            this.metadata = new HashMap<String, Object>();
            if (pattern != null) {
                this.metadata.put("data-p-pattern", CalendarUtils.convertPattern(pattern));
            }
            if (type != null) {
                String typeCleared = type;
                if ("localDate".equalsIgnoreCase(typeCleared)) {
                    typeCleared = "date";
                } else if ("localTime".equalsIgnoreCase(typeCleared)) {
                    typeCleared = "time";
                } else if ("localDateTime".equalsIgnoreCase(typeCleared)) {
                    typeCleared = "both";
                }
                this.metadata.put("data-p-dttype", typeCleared);
                if (pattern == null) {
                    DateFormat df = null;
                    if ("both".equals(type)) {
                        df = DateFormat.getDateInstance(this.getStyle(dateStyle), this.getLocale());
                        this.metadata.put("data-p-dspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                        df = DateFormat.getTimeInstance(this.getStyle(timeStyle), this.getLocale());
                        this.metadata.put("data-p-tspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                    } else if ("date".equals(type)) {
                        df = DateFormat.getDateInstance(this.getStyle(dateStyle), this.getLocale());
                        this.metadata.put("data-p-dspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                    } else if ("time".equals(type)) {
                        df = DateFormat.getTimeInstance(this.getStyle(timeStyle), this.getLocale());
                        this.metadata.put("data-p-tspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                    }
                }
            }
        }
        return this.metadata;
    }

    @Override
    public String getConverterId() {
        return "jakarta.faces.DateTime";
    }

    private int getStyle(String style) {
        if ("default".equals(style)) {
            return 2;
        }
        if ("short".equals(style)) {
            return 3;
        }
        if ("medium".equals(style)) {
            return 2;
        }
        if ("long".equals(style)) {
            return 1;
        }
        if ("full".equals(style)) {
            return 0;
        }
        throw new ConverterException("Invalid style '" + style + '\'');
    }
}

