/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.csp;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import org.primefaces.PrimeFaces;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeFacesContext;
import org.primefaces.csp.CspState;
import org.primefaces.shaded.owasp.encoder.Encode;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;

public class CspPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private Lazy<Boolean> enabled = new Lazy(() -> PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConfig().isCsp());
    private Lazy<Boolean> policyProvided = new Lazy(() -> PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConfig().isPolicyProvided());
    private Lazy<String> customPolicy = new Lazy(() -> PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConfig().getCspPolicy());
    private Lazy<String> reportOnlyPolicy = new Lazy(() -> PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConfig().getCspReportOnlyPolicy());

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        String policy;
        if (Boolean.FALSE.equals(this.enabled.get()) || Boolean.TRUE.equals(this.policyProvided.get())) {
            return;
        }
        FacesContext context = event.getFacesContext();
        ExternalContext externalContext = context.getExternalContext();
        CspState state = PrimeFacesContext.getCspState(context);
        if (LangUtils.isNotBlank(this.reportOnlyPolicy.get())) {
            policy = "script-src 'self' 'nonce-" + state.getNonce() + "'; " + this.reportOnlyPolicy.get() + ";";
            externalContext.addResponseHeader("Content-Security-Policy-Report-Only", policy);
        } else {
            policy = LangUtils.isBlank(this.customPolicy.get()) ? "script-src 'self'" : this.customPolicy.get();
            policy = policy + " 'nonce-" + state.getNonce() + "';";
            externalContext.addResponseHeader("Content-Security-Policy", policy);
        }
        String init = "if(window.PrimeFaces){PrimeFaces.csp.init('" + Encode.forJavaScript(state.getNonce()) + "');};";
        PrimeFaces.current().executeInitScript(init);
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

