/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.event;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.component.behavior.Behavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import java.util.ArrayList;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.UITree;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.event.AbstractAjaxBehaviorEvent;

public class CellEditEvent<T>
extends AbstractAjaxBehaviorEvent {
    private static final long serialVersionUID = 1L;
    private T oldValue;
    private T newValue;
    private int rowIndex;
    private UIColumn column;
    private String rowKey;

    public CellEditEvent(UIComponent component, Behavior behavior, int rowIndex, UIColumn column) {
        super(component, behavior);
        this.rowIndex = rowIndex;
        this.column = column;
        this.oldValue = this.resolveValue();
    }

    public CellEditEvent(UIComponent component, Behavior behavior, int rowIndex, UIColumn column, String rowKey) {
        this(component, behavior, rowIndex, column);
        this.rowKey = rowKey;
    }

    public CellEditEvent(UIComponent component, Behavior behavior, UIColumn column, String rowKey) {
        super(component, behavior);
        this.rowKey = rowKey;
        this.column = column;
        this.oldValue = this.resolveValue();
    }

    public T getOldValue() {
        return this.oldValue;
    }

    public T getNewValue() {
        if (this.newValue == null) {
            this.newValue = this.resolveValue();
        }
        return this.newValue;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public UIColumn getColumn() {
        return this.column;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    private T resolveValue() {
        ClientBehaviorHolder data;
        if (this.source instanceof UIData) {
            data = (DataTable)this.source;
            data.setRowModel(this.rowIndex);
        } else if (this.source instanceof UITree) {
            data = (TreeTable)this.source;
            data.setRowKey(data.getValue(), this.rowKey);
        }
        if (this.column.isDynamic()) {
            DynamicColumn dynamicColumn = (DynamicColumn)this.column;
            dynamicColumn.applyStatelessModel();
        }
        ArrayList<Object> value = null;
        for (UIComponent child : this.column.getChildren()) {
            if (!(child instanceof CellEditor)) continue;
            UIComponent inputFacet = child.getFacet("input");
            if (inputFacet instanceof UIPanel) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (UIComponent kid : inputFacet.getChildren()) {
                    if (!(kid instanceof ValueHolder)) continue;
                    values.add(((ValueHolder)kid).getValue());
                }
                value = values;
                continue;
            }
            value = ((ValueHolder)inputFacet).getValue();
        }
        return (T)value;
    }
}

