/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression.impl;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.expression.MultiSearchExpressionResolver;
import org.primefaces.expression.SearchExpressionHint;
import org.primefaces.expression.SearchExpressionResolver;
import org.primefaces.util.ComponentTraversalUtils;

public class IdExpressionResolver
implements SearchExpressionResolver,
MultiSearchExpressionResolver {
    private static final Pattern PATTERN = Pattern.compile("@id\\(([\\w-]+)\\)");

    @Override
    public UIComponent resolveComponent(FacesContext context, UIComponent source, UIComponent last, String expression, Set<SearchExpressionHint> hints) {
        return ComponentTraversalUtils.firstWithId(this.extractId(expression), last);
    }

    @Override
    public void resolveComponents(FacesContext context, UIComponent source, UIComponent last, String expression, List<UIComponent> components, Set<SearchExpressionHint> hints) {
        ComponentTraversalUtils.withId(this.extractId(expression), last, components);
    }

    protected String extractId(String expression) {
        try {
            Matcher matcher = PATTERN.matcher(expression);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            throw new FacesException("Expression does not match following pattern @id(id). Expression: \"" + expression + "\"");
        }
        catch (Exception e) {
            throw new FacesException("Expression does not match following pattern @id(id). Expression: \"" + expression + "\"", (Throwable)e);
        }
    }
}

