/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression.impl;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchKeywordContext;
import jakarta.faces.component.search.SearchKeywordResolver;
import jakarta.faces.component.visit.VisitCallback;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.expression.impl.WidgetVarVisitCallback;

public class Jsf23WidgetVarSearchKeywordResolver
extends SearchKeywordResolver {
    private static final Pattern PATTERN = Pattern.compile("widgetVar\\((\\w+)\\)");

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return keyword != null && keyword.startsWith("widgetVar(");
    }

    public void resolve(SearchKeywordContext context, UIComponent current, String keyword) {
        try {
            Matcher matcher = PATTERN.matcher(keyword);
            if (!matcher.matches()) {
                throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + keyword + "\"");
            }
            WidgetVarVisitCallback visitCallback = new WidgetVarVisitCallback(matcher.group(1));
            context.getSearchExpressionContext().getFacesContext().getViewRoot().visitTree(SearchExpressionUtils.createVisitContext(context.getSearchExpressionContext().getFacesContext(), SearchExpressionUtils.SET_SKIP_UNRENDERED), (VisitCallback)visitCallback);
            context.invokeContextCallback(visitCallback.getComponent());
        }
        catch (Exception e) {
            throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + keyword + "\"", (Throwable)e);
        }
    }
}

