/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.metadata.transformer;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.html.HtmlInputSecret;
import jakarta.faces.component.html.HtmlInputText;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.primefaces.component.inputtextarea.InputTextarea;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.metadata.transformer.MetadataTransformer;

public abstract class AbstractInputMetadataTransformer
implements MetadataTransformer {
    @Override
    public void transform(FacesContext context, PrimeApplicationContext applicationContext, UIComponent component) throws IOException {
        if (component instanceof EditableValueHolder && component instanceof UIInput) {
            this.transformInput(context, applicationContext, (UIInput)component);
        }
    }

    protected abstract void transformInput(FacesContext var1, PrimeApplicationContext var2, UIInput var3) throws IOException;

    protected void setMaxlength(UIInput input, int maxlength) {
        if (input instanceof HtmlInputText) {
            ((HtmlInputText)input).setMaxlength(maxlength);
        } else if (input instanceof HtmlInputSecret) {
            ((HtmlInputSecret)input).setMaxlength(maxlength);
        } else if (input instanceof InputTextarea) {
            ((InputTextarea)input).setMaxlength(maxlength);
        }
    }

    protected int getMaxlength(UIInput input) {
        if (input instanceof HtmlInputText) {
            return ((HtmlInputText)input).getMaxlength();
        }
        if (input instanceof HtmlInputSecret) {
            return ((HtmlInputSecret)input).getMaxlength();
        }
        if (input instanceof InputTextarea) {
            ((InputTextarea)input).getMaxlength();
        }
        return Integer.MIN_VALUE;
    }

    protected boolean isMaxlenghtSet(UIInput input) {
        return this.getMaxlength(input) != Integer.MIN_VALUE;
    }
}

