/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.metadata.transformer;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.PreRenderComponentEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.metadata.transformer.MetadataTransformer;
import org.primefaces.metadata.transformer.impl.BeanValidationInputMetadataTransformer;

public class MetadataTransformerExecutor
implements SystemEventListener {
    private static final List<MetadataTransformer> METADATA_TRANSFORMERS = new ArrayList<MetadataTransformer>();
    private static final MetadataTransformer BV_INPUT_METADATA_TRANSFORMER = new BeanValidationInputMetadataTransformer();

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        try {
            if (event instanceof PreRenderComponentEvent) {
                PreRenderComponentEvent preRenderComponentEvent = (PreRenderComponentEvent)event;
                MetadataTransformerExecutor.execute(PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()), preRenderComponentEvent.getComponent());
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIComponent;
    }

    public static void execute(PrimeApplicationContext applicationContext, UIComponent component) throws IOException {
        if (applicationContext.getConfig().isTransformMetadataEnabled()) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (applicationContext.getConfig().isBeanValidationEnabled()) {
                BV_INPUT_METADATA_TRANSFORMER.transform(context, applicationContext, component);
            }
            if (!METADATA_TRANSFORMERS.isEmpty()) {
                for (int i = 0; i < METADATA_TRANSFORMERS.size(); ++i) {
                    METADATA_TRANSFORMERS.get(i).transform(context, applicationContext, component);
                }
            }
        }
    }

    public static void registerMetadataTransformer(MetadataTransformer metadataTransformer) {
        METADATA_TRANSFORMERS.add(metadataTransformer);
    }

    public static MetadataTransformer removeMetadataTransformer(Class<? extends MetadataTransformer> clazz) {
        Iterator<MetadataTransformer> iterator = METADATA_TRANSFORMERS.iterator();
        while (iterator.hasNext()) {
            MetadataTransformer metadataTransformer = iterator.next();
            if (!metadataTransformer.getClass().equals(clazz)) continue;
            iterator.remove();
            return metadataTransformer;
        }
        return null;
    }
}

