/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.util.BeanUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;
import org.primefaces.util.SerializableSupplier;

public class JpaLazyDataModel<T>
extends LazyDataModel<T>
implements Serializable {
    protected Class<T> entityClass;
    protected SerializableSupplier<EntityManager> entityManager;
    protected String rowKeyField;
    private transient Lazy<Method> rowKeyGetter;

    public JpaLazyDataModel() {
    }

    public JpaLazyDataModel(Class<T> entityClass, SerializableSupplier<EntityManager> entityManager) {
        this.entityClass = entityClass;
        this.entityManager = entityManager;
    }

    public JpaLazyDataModel(Class<T> entityClass, SerializableSupplier<EntityManager> entityManager, String rowKeyField) {
        this(entityClass, entityManager);
        this.rowKeyField = rowKeyField;
    }

    public JpaLazyDataModel(Class<T> entityClass, SerializableSupplier<EntityManager> entityManager, Converter converter) {
        super(converter);
        this.entityClass = entityClass;
        this.entityManager = entityManager;
    }

    @Override
    public int count(Map<String, FilterMeta> filterBy) {
        EntityManager em = (EntityManager)this.entityManager.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root root = cq.from(this.entityClass);
        cq = cq.select((Selection)cb.count((Expression)root));
        this.applyFilters(cb, cq, root, filterBy);
        return ((Long)em.createQuery(cq).getSingleResult()).intValue();
    }

    @Override
    public List<T> load(int first, int pageSize, Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        EntityManager em = (EntityManager)this.entityManager.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(this.entityClass);
        Root root = cq.from(this.entityClass);
        cq = cq.select((Selection)root);
        this.applyFilters(cb, cq, root, filterBy);
        this.applySort(cb, cq, root, sortBy);
        TypedQuery query = em.createQuery(cq);
        query.setFirstResult(first);
        query.setMaxResults(pageSize);
        List result = query.getResultList();
        return result;
    }

    protected void applyFilters(CriteriaBuilder cb, CriteriaQuery<?> cq, Root<T> root, Map<String, FilterMeta> filterBy) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.applyGlobalFilters(filterBy, cb, cq, root, predicates);
        if (filterBy != null) {
            for (FilterMeta filter : filterBy.values()) {
                if (filter.getField() == null || filter.getFilterValue() == null || filter.isGlobalFilter()) continue;
                String filterValue = filter.getFilterValue().toString();
                Field filterField = LangUtils.getFieldRecursive(this.entityClass, filter.getField());
                Object convertedFilterValue = this.convertToType(filterValue, filterField.getType());
                Expression fieldExpression = this.resolveFieldExpression(cb, cq, root, filter.getField());
                Predicate predicate = this.createPredicate(filter, filterField, root, cb, fieldExpression, (Comparable)convertedFilterValue);
                predicates.add(predicate);
            }
        }
        if (!predicates.isEmpty()) {
            cq.where((Expression)cb.and(predicates.toArray(new Predicate[predicates.size()])));
        }
    }

    protected void applyGlobalFilters(Map<String, FilterMeta> filterBy, CriteriaBuilder cb, CriteriaQuery<?> cq, Root<T> root, List<Predicate> predicates) {
    }

    protected <F extends Comparable> Predicate createPredicate(FilterMeta filter, Field filterField, Root<T> root, CriteriaBuilder cb, Expression fieldExpression, F filterValue) {
        Lazy fieldExpressionAsString = new Lazy(() -> fieldExpression.as(String.class));
        switch (filter.getMatchMode()) {
            case STARTS_WITH: {
                return cb.like((Expression)fieldExpressionAsString.get(), filterValue + "%");
            }
            case NOT_STARTS_WITH: {
                return cb.notLike((Expression)fieldExpressionAsString.get(), filterValue + "%");
            }
            case ENDS_WITH: {
                return cb.like((Expression)fieldExpressionAsString.get(), "%" + filterValue);
            }
            case NOT_ENDS_WITH: {
                return cb.notLike((Expression)fieldExpressionAsString.get(), "%" + filterValue);
            }
            case CONTAINS: {
                return cb.like((Expression)fieldExpressionAsString.get(), "%" + filterValue + "%");
            }
            case NOT_CONTAINS: {
                return cb.notLike((Expression)fieldExpressionAsString.get(), "%" + filterValue + "%");
            }
            case EXACT: 
            case EQUALS: {
                return cb.equal(fieldExpression, filterValue);
            }
            case NOT_EXACT: 
            case NOT_EQUALS: {
                return cb.notEqual(fieldExpression, filterValue);
            }
            case LESS_THAN: {
                return cb.lessThan(fieldExpression, filterValue);
            }
            case LESS_THAN_EQUALS: {
                return cb.lessThanOrEqualTo(fieldExpression, filterValue);
            }
            case GREATER_THAN: {
                return cb.greaterThan(fieldExpression, filterValue);
            }
            case GREATER_THAN_EQUALS: {
                return cb.greaterThanOrEqualTo(fieldExpression, filterValue);
            }
            case IN: {
                throw new UnsupportedOperationException("MatchMode.IN currently not supported!");
            }
            case NOT_IN: {
                throw new UnsupportedOperationException("MatchMode.NOT_IN currently not supported!");
            }
            case BETWEEN: {
                throw new UnsupportedOperationException("MatchMode.BETWEEN currently not supported!");
            }
            case NOT_BETWEEN: {
                throw new UnsupportedOperationException("MatchMode.NOT_BETWEEN currently not supported!");
            }
            case GLOBAL: {
                throw new UnsupportedOperationException("MatchMode.GLOBAL currently not supported!");
            }
        }
        return null;
    }

    protected void applySort(CriteriaBuilder cb, CriteriaQuery<T> cq, Root<T> root, Map<String, SortMeta> sortBy) {
        if (sortBy != null) {
            ArrayList<Order> orders = null;
            for (SortMeta sort : sortBy.values()) {
                if (sort.getField() == null || sort.getOrder() == SortOrder.UNSORTED) continue;
                if (orders == null) {
                    orders = new ArrayList<Order>();
                }
                Expression fieldExpression = this.resolveFieldExpression(cb, cq, root, sort.getField());
                orders.add(sort.getOrder() == SortOrder.ASCENDING ? cb.asc(fieldExpression) : cb.desc(fieldExpression));
            }
            if (orders != null) {
                cq.orderBy(orders);
            }
        }
    }

    protected Expression resolveFieldExpression(CriteriaBuilder cb, CriteriaQuery<?> cq, Root<T> root, String fieldName) {
        Join join = null;
        while (fieldName.contains(".")) {
            String currentName = fieldName.substring(0, fieldName.indexOf("."));
            fieldName = fieldName.substring(currentName.length() + 1);
            if (join == null) {
                join = root.join(currentName, JoinType.INNER);
                continue;
            }
            join = join.join(currentName, JoinType.INNER);
        }
        return join == null ? root.get(fieldName) : join.get(fieldName);
    }

    @Override
    public T getRowData(String rowKey) {
        Converter converter = this.getConverter();
        if (converter != null) {
            return super.getRowData(rowKey);
        }
        if (this.rowKeyField != null) {
            Object convertedRowKey = this.convertToType(rowKey, this.getRowKeyGetter().getReturnType());
            EntityManager em = (EntityManager)this.entityManager.get();
            CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
            CriteriaQuery cq = criteriaBuilder.createQuery(this.entityClass);
            Root root = cq.from(this.entityClass);
            cq.select((Selection)root).where((Expression)criteriaBuilder.equal((Expression)root.get(this.rowKeyField), convertedRowKey));
            TypedQuery query = em.createQuery(cq);
            return (T)query.getSingleResult();
        }
        throw new UnsupportedOperationException(this.getMessage("Provide a Converter or rowKeyField via constructor or implement getRowData(String rowKey) in %s, when basic rowKey algorithm is not used [component=%s,view=%s]."));
    }

    @Override
    public String getRowKey(T object) {
        Converter converter = this.getConverter();
        if (converter != null) {
            return super.getRowKey(object);
        }
        if (this.rowKeyField != null) {
            try {
                Object rowKey = this.getRowKeyGetter().invoke(object, new Object[0]);
                return rowKey == null ? null : rowKey.toString();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new FacesException("Could not invoke getter for " + this.rowKeyField + " on " + this.entityClass.getName(), (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(this.getMessage("Provide a Converter or rowKeyField via constructor or implement getRowKey(T object) in %s, when basic rowKey algorithm is not used [component=%s,view=%s]."));
    }

    protected <V> V convertToType(String value, Class<V> valueType) {
        FacesContext context = FacesContext.getCurrentInstance();
        Converter converter = context.getApplication().createConverter(valueType);
        if (converter != null) {
            return (V)converter.getAsObject(context, UIComponent.getCurrentComponent((FacesContext)context), value);
        }
        if (valueType == String.class) {
            return (V)value;
        }
        if (BeanUtils.isPrimitiveOrPrimitiveWrapper(valueType)) {
            return (V)FacesContext.getCurrentInstance().getELContext().convertToType((Object)value, valueType);
        }
        throw new FacesException("Can not convert " + value + " to type " + valueType + "; please create a JSF Converter for it or overwrite Object convertToType(String value, Class<?> valueType)!");
    }

    protected Method getRowKeyGetter() {
        if (this.rowKeyGetter == null) {
            this.rowKeyGetter = new Lazy(() -> {
                try {
                    return new PropertyDescriptor(this.rowKeyField, this.entityClass).getReadMethod();
                }
                catch (IntrospectionException e) {
                    throw new FacesException("Could not access " + this.rowKeyField + " on " + this.entityClass.getName(), (Throwable)e);
                }
            });
        }
        return this.rowKeyGetter.get();
    }
}

