/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.file;

import jakarta.faces.FacesException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.shaded.commons.io.FilenameUtils;
import org.primefaces.util.FileUploadUtils;

public class NIOUploadedFile
implements UploadedFile,
Serializable {
    private Path file;
    private String filename;
    private byte[] content;
    private String contentType;

    public NIOUploadedFile() {
    }

    public NIOUploadedFile(Path file, String filename, String contentType) {
        this.file = file;
        this.filename = filename;
        this.contentType = contentType;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    @Override
    public byte[] getContent() {
        if (this.content == null) {
            try {
                this.content = Files.readAllBytes(this.file);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return this.content;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getSize() {
        try {
            return Files.size(this.file);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    @Override
    public void write(String filePath) throws Exception {
        String validFileName = FileUploadUtils.getValidFilename(FilenameUtils.getName(this.getFileName()));
        Files.copy(this.file, Paths.get(validFileName, new String[0]), new CopyOption[0]);
    }

    @Override
    public void delete() throws IOException {
        Files.delete(this.file);
    }
}

