/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import jakarta.el.PropertyNotFoundException;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.render.Renderer;
import jakarta.faces.validator.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.api.ClientBehaviorRenderingMode;
import org.primefaces.component.api.MixedClientBehaviorHolder;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.convert.ClientConverter;
import org.primefaces.util.AjaxRequestBuilder;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.Jsf22Helper;
import org.primefaces.util.LangUtils;
import org.primefaces.util.ResourceUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.StyleBuilder;
import org.primefaces.util.StyleClassBuilder;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;
import org.primefaces.validate.bean.BeanValidationMetadata;
import org.primefaces.validate.bean.BeanValidationMetadataMapper;

public abstract class CoreRenderer
extends Renderer {
    private static final Logger LOGGER = Logger.getLogger(CoreRenderer.class.getName());
    private static final String SB_RENDER_DOM_EVENTS = CoreRenderer.class.getName() + "#renderDomEvents";
    private static final String SB_BUILD_NON_AJAX_REQUEST = CoreRenderer.class.getName() + "#buildNonAjaxRequest";
    private static final String SB_GET_EVENT_BEHAVIORS = CoreRenderer.class.getName() + "#getEventBehaviors";
    private static final String SB_RENDER_VALIDATOR_IDS = CoreRenderer.class.getName() + "#renderValidatorIds";

    protected void renderChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (int i = 0; i < component.getChildCount(); ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                this.renderChild(context, child);
            }
        }
    }

    protected void renderChild(FacesContext context, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(context);
        if (child.getRendersChildren()) {
            child.encodeChildren(context);
        } else {
            this.renderChildren(context, child);
        }
        child.encodeEnd(context);
    }

    protected String getResourceURL(FacesContext context, String value) {
        return ResourceUtils.getResourceURL(context, value);
    }

    protected String getResourceRequestPath(FacesContext context, String resourceName) {
        return ResourceUtils.getResourceRequestPath(context, resourceName);
    }

    protected void renderPassThruAttributes(FacesContext context, UIComponent component, List<String> attrs) throws IOException {
        if (attrs != null && !attrs.isEmpty()) {
            ResponseWriter writer = context.getResponseWriter();
            for (int i = 0; i < attrs.size(); ++i) {
                String attribute = attrs.get(i);
                Object value = component.getAttributes().get(attribute);
                if (!this.shouldRenderAttribute(value)) continue;
                writer.writeAttribute(attribute, (Object)value.toString(), attribute);
            }
        }
        this.renderDynamicPassThruAttributes(context, component);
    }

    @SafeVarargs
    protected final void renderPassThruAttributes(FacesContext context, UIComponent component, List<String> ... attrs) throws IOException {
        if (attrs == null || attrs.length == 0) {
            this.renderDynamicPassThruAttributes(context, component);
            return;
        }
        for (List<String> a : attrs) {
            this.renderPassThruAttributes(context, component, a);
        }
    }

    protected void renderDynamicPassThruAttributes(FacesContext context, UIComponent component) throws IOException {
        if (PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isAtLeastJsf22()) {
            Jsf22Helper.renderPassThroughAttributes(context, component);
        }
    }

    protected void renderDomEvents(FacesContext context, UIComponent component, List<String> eventAttrs) throws IOException {
        if (component instanceof ClientBehaviorHolder) {
            this.renderDomEvents(context, component, eventAttrs, ((ClientBehaviorHolder)component).getClientBehaviors());
        } else {
            this.renderPassThruAttributes(context, component, eventAttrs);
        }
    }

    private void renderDomEvents(FacesContext context, UIComponent component, List<String> eventAttrs, Map<String, List<ClientBehavior>> behaviors) throws IOException {
        if (eventAttrs == null || eventAttrs.isEmpty()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        StringBuilder builder = null;
        for (int i = 0; i < eventAttrs.size(); ++i) {
            boolean hasEventBehaviors;
            String domEvent = eventAttrs.get(i);
            Object eventValue = component.getAttributes().get(domEvent);
            String behaviorEvent = domEvent.substring(2, domEvent.length());
            List<ClientBehavior> eventBehaviors = behaviors.get(behaviorEvent);
            boolean hasEventValue = eventValue != null;
            boolean bl = hasEventBehaviors = eventBehaviors != null && !eventBehaviors.isEmpty();
            if ("onchange".equals(domEvent) && !hasEventBehaviors) {
                eventBehaviors = behaviors.get("valueChange");
                boolean bl2 = hasEventBehaviors = eventBehaviors != null && !eventBehaviors.isEmpty();
                if (hasEventBehaviors) {
                    behaviorEvent = "valueChange";
                }
            }
            if (!hasEventValue && !hasEventBehaviors) continue;
            if (builder == null) {
                builder = SharedStringBuilder.get(context, SB_RENDER_DOM_EVENTS);
            }
            if (hasEventBehaviors) {
                String clientId = component.getClientId(context);
                ArrayList<ClientBehaviorContext.Parameter> params = new ArrayList<ClientBehaviorContext.Parameter>(1);
                params.add(new ClientBehaviorContext.Parameter("CLIENT_BEHAVIOR_RENDERING_MODE", (Object)ClientBehaviorRenderingMode.OBSTRUSIVE));
                ClientBehaviorContext cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)component, (String)behaviorEvent, (String)clientId, params);
                int size = eventBehaviors.size();
                boolean chained = false;
                if (size > 1 || hasEventValue) {
                    builder.append("PrimeFaces.bcn(this,event,[");
                    if (hasEventValue) {
                        builder.append("function(event){").append(eventValue).append("}");
                        chained = true;
                    }
                    for (int j = 0; j < size; ++j) {
                        ClientBehavior behavior = eventBehaviors.get(j);
                        String script = behavior.getScript(cbc);
                        if (script == null) continue;
                        if (chained) {
                            builder.append(",");
                        }
                        builder.append("function(event){").append(script).append("}");
                        chained = true;
                    }
                    builder.append("])");
                } else {
                    ClientBehavior behavior = eventBehaviors.get(0);
                    String script = behavior.getScript(cbc);
                    if (script != null) {
                        builder.append(script);
                    }
                }
            } else if (hasEventValue) {
                builder.append(eventValue);
            }
            if (builder.length() <= 0) continue;
            writer.writeAttribute(domEvent, (Object)builder.toString(), domEvent);
            builder.setLength(0);
        }
    }

    protected void renderPassThruAttributes(FacesContext context, UIComponent component, String[] attrs, String[] ignoredAttrs) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (String attribute : attrs) {
            Object value;
            if (this.isIgnoredAttribute(attribute, ignoredAttrs) || !this.shouldRenderAttribute(value = component.getAttributes().get(attribute))) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
        if (PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isAtLeastJsf22()) {
            Jsf22Helper.renderPassThroughAttributes(context, component);
        }
    }

    protected void renderOnchange(FacesContext context, UIComponent component) throws IOException {
        this.renderDomEvent(context, component, "onchange", "change", "valueChange", null);
    }

    protected void renderOnclick(FacesContext context, UIComponent component, String command) throws IOException {
        this.renderDomEvent(context, component, "onclick", "click", "action", command);
    }

    protected void renderDomEvent(FacesContext context, UIComponent component, String domEvent, String behaviorEvent, String behaviorEventAlias, String command) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String callback = this.buildDomEvent(context, component, domEvent, behaviorEvent, behaviorEventAlias, command);
        if (callback != null) {
            writer.writeAttribute(domEvent, (Object)callback, domEvent);
        }
    }

    protected void renderHiddenInput(FacesContext context, String id, String value, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
    }

    protected String buildDomEvent(FacesContext context, UIComponent component, String domEvent, String behaviorEvent, String behaviorEventAlias, String command) {
        boolean hasBehaviors;
        Object event;
        StringBuilder builder = null;
        boolean hasCommand = command != null;
        Map allBehaviors = null;
        if (component instanceof ClientBehaviorHolder) {
            allBehaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        }
        boolean hasEvent = (event = component.getAttributes().get(domEvent)) != null;
        String behaviorEventName = behaviorEventAlias;
        if (allBehaviors != null && allBehaviors.containsKey(behaviorEvent)) {
            behaviorEventName = behaviorEvent;
        }
        List behaviors = allBehaviors == null ? null : (List)allBehaviors.get(behaviorEventName);
        boolean bl = hasBehaviors = behaviors != null && !behaviors.isEmpty();
        if (hasEvent || hasBehaviors || hasCommand) {
            if (builder == null) {
                builder = SharedStringBuilder.get(context, SB_RENDER_DOM_EVENTS);
            }
            int commandSize = 0;
            if (hasBehaviors) {
                commandSize += behaviors.size();
            }
            if (hasEvent) {
                ++commandSize;
            }
            if (hasCommand) {
                ++commandSize;
            }
            if (commandSize > 1) {
                boolean first = true;
                builder.append("PrimeFaces.bcn(this,event,[");
                if (hasEvent) {
                    builder.append("function(event){").append(event).append("}");
                    first = false;
                }
                if (hasBehaviors) {
                    ClientBehaviorContext cbc = null;
                    for (int i = 0; i < behaviors.size(); ++i) {
                        String script;
                        ClientBehavior behavior = (ClientBehavior)behaviors.get(i);
                        if (cbc == null) {
                            cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)component, (String)behaviorEventName, (String)component.getClientId(context), Collections.emptyList());
                        }
                        if ((script = behavior.getScript(cbc)) == null) continue;
                        if (!first) {
                            builder.append(",");
                        }
                        builder.append("function(event){").append(script).append("}");
                        first = false;
                    }
                }
                if (hasCommand) {
                    if (!first) {
                        builder.append(",");
                    }
                    builder.append("function(event){").append(command).append("}");
                    first = false;
                }
                builder.append("]);");
            } else if (hasBehaviors) {
                ClientBehaviorContext cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)component, (String)behaviorEventName, (String)component.getClientId(context), Collections.emptyList());
                ClientBehavior behavior = (ClientBehavior)behaviors.get(0);
                String script = behavior.getScript(cbc);
                if (script != null) {
                    builder.append(script);
                }
            } else if (hasCommand) {
                builder.append(command);
            } else if (hasEvent) {
                builder.append(event);
            }
        }
        return builder == null ? null : builder.toString();
    }

    private boolean isIgnoredAttribute(String attribute, String[] ignoredAttrs) {
        for (String ignoredAttribute : ignoredAttrs) {
            if (!attribute.equals(ignoredAttribute)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldRenderAttribute(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Integer) {
                return number.intValue() != Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return number.doubleValue() != Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return number.longValue() != Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return number.byteValue() != -128;
            }
            if (value instanceof Float) {
                return number.floatValue() != Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return number.shortValue() != Short.MIN_VALUE;
            }
        }
        return true;
    }

    public boolean isValueBlank(String value) {
        return LangUtils.isBlank(value);
    }

    protected <T extends UIComponent> AjaxRequestBuilder preConfiguredAjaxRequestBuilder(FacesContext context, T source) {
        return this.preConfiguredAjaxRequestBuilder(context, source, (AjaxSource)source, null);
    }

    protected AjaxRequestBuilder preConfiguredAjaxRequestBuilder(FacesContext context, UIComponent component, AjaxSource source, UIForm form) {
        String clientId = component.getClientId(context);
        AjaxRequestBuilder builder = PrimeRequestContext.getCurrentInstance(context).getAjaxRequestBuilder();
        builder.init().source(clientId).form(source, component, form).process(component, source.getProcess(), source.isIgnoreComponentNotFound()).update(component, source.getUpdate(), source.isIgnoreComponentNotFound()).async(source.isAsync()).global(source.isGlobal()).delay(source.getDelay()).timeout(source.getTimeout()).partialSubmit(source.isPartialSubmit(), source.isPartialSubmitSet(), source.getPartialSubmitFilter()).resetValues(source.isResetValues(), source.isResetValuesSet()).ignoreAutoUpdate(source.isIgnoreAutoUpdate()).onstart(source.getOnstart()).onerror(source.getOnerror()).onsuccess(source.getOnsuccess()).oncomplete(source.getOncomplete());
        return builder;
    }

    protected <T extends UIComponent> String buildAjaxRequest(FacesContext context, T source) {
        return this.buildAjaxRequest(context, source, null);
    }

    protected <T extends UIComponent> String buildAjaxRequest(FacesContext context, T source, UIForm form) {
        AjaxRequestBuilder builder = this.preConfiguredAjaxRequestBuilder(context, source, (AjaxSource)source, form).params(source).preventDefault();
        return builder.build();
    }

    protected String buildAjaxRequest(FacesContext context, UIComponent component, AjaxSource source, UIForm form, Map<String, List<String>> params) {
        AjaxRequestBuilder builder = this.preConfiguredAjaxRequestBuilder(context, component, source, form).params(params).preventDefault();
        return builder.build();
    }

    protected String buildNonAjaxRequest(FacesContext context, UIComponent component, UIComponent form, String decodeParam, boolean submit) {
        return this.buildNonAjaxRequest(context, component, form, decodeParam, Collections.emptyMap(), submit);
    }

    protected String buildNonAjaxRequest(FacesContext context, UIComponent component, UIComponent form, String decodeParam, Map<String, List<String>> parameters, boolean submit) {
        StringBuilder request = SharedStringBuilder.get(context, SB_BUILD_NON_AJAX_REQUEST);
        String submitId = form == null ? component.getClientId(context) : form.getClientId(context);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (decodeParam != null) {
            params.put(decodeParam, decodeParam);
        }
        for (int i = 0; i < component.getChildCount(); ++i) {
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            params.put(param.getName(), param.getValue());
        }
        if (parameters != null && !parameters.isEmpty()) {
            parameters.forEach((k, v) -> params.put((String)k, v.get(0)));
        }
        if (!params.isEmpty()) {
            request.append("PrimeFaces.addSubmitParam('").append(submitId).append("',{");
            request.append(params.entrySet().stream().map(e -> "'" + (String)e.getKey() + "':'" + EscapeUtils.forJavaScript(String.valueOf(e.getValue())) + "'").collect(Collectors.joining(",")));
            request.append("})");
        }
        if (submit) {
            Object target = component.getAttributes().get("target");
            request.append(".submit('").append(submitId).append("'");
            if (target != null) {
                request.append(",'").append(target).append("'");
            }
            request.append(");return false;");
        }
        if (!submit && !params.isEmpty()) {
            request.append(";");
        }
        return request.toString();
    }

    protected void encodeClientBehaviors(FacesContext context, ClientBehaviorHolder component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map clientBehaviors = component.getClientBehaviors();
        if (clientBehaviors != null && !clientBehaviors.isEmpty()) {
            boolean written = false;
            Collection<Object> eventNames = component instanceof MixedClientBehaviorHolder ? ((MixedClientBehaviorHolder)component).getUnobstrusiveEventNames() : clientBehaviors.keySet();
            String clientId = ((UIComponent)component).getClientId(context);
            ArrayList<ClientBehaviorContext.Parameter> params = new ArrayList<ClientBehaviorContext.Parameter>(1);
            params.add(new ClientBehaviorContext.Parameter("CLIENT_BEHAVIOR_RENDERING_MODE", (Object)ClientBehaviorRenderingMode.UNOBSTRUSIVE));
            writer.write(",behaviors:{");
            for (String string : eventNames) {
                List eventBehaviors = (List)clientBehaviors.get(string);
                if (eventBehaviors == null || eventBehaviors.isEmpty()) continue;
                if (written) {
                    writer.write(",");
                }
                int eventBehaviorsSize = eventBehaviors.size();
                writer.write(string + ":");
                writer.write("function(ext,event) {");
                if (eventBehaviorsSize > 1) {
                    boolean chained = false;
                    writer.write("PrimeFaces.bcnu(ext,event,[");
                    for (int i = 0; i < eventBehaviorsSize; ++i) {
                        ClientBehaviorContext cbc;
                        ClientBehavior behavior = (ClientBehavior)eventBehaviors.get(i);
                        String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)string, (String)clientId, params));
                        if (script == null) continue;
                        if (chained) {
                            writer.write(",");
                        }
                        writer.write("function(ext,event) {");
                        writer.write(script);
                        writer.write("}");
                        chained = true;
                    }
                    writer.write("]);");
                } else {
                    ClientBehaviorContext cbc;
                    ClientBehavior behavior = (ClientBehavior)eventBehaviors.get(0);
                    String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)string, (String)clientId, params));
                    if (script != null) {
                        writer.write(script);
                    }
                }
                writer.write("}");
                written = true;
            }
            writer.write("}");
        }
    }

    protected void decodeBehaviors(FacesContext context, UIComponent component) {
        ComponentUtils.decodeBehaviors(context, component);
    }

    protected String getEventBehaviors(FacesContext context, ClientBehaviorHolder cbh, String event, List<ClientBehaviorContext.Parameter> parameters) {
        List behaviors = (List)cbh.getClientBehaviors().get(event);
        StringBuilder sb = SharedStringBuilder.get(context, SB_GET_EVENT_BEHAVIORS);
        if (behaviors != null && !behaviors.isEmpty()) {
            UIComponent component = (UIComponent)cbh;
            String clientId = component.getClientId(context);
            List<Object> params = parameters != null && !parameters.isEmpty() ? parameters : Collections.emptyList();
            for (int i = 0; i < behaviors.size(); ++i) {
                ClientBehaviorContext cbc;
                ClientBehavior behavior = (ClientBehavior)behaviors.get(i);
                String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)component, (String)event, (String)clientId, params));
                if (script == null) continue;
                sb.append(script).append(";");
            }
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    protected boolean shouldWriteId(UIComponent component) {
        String id = component.getId();
        return null != id && (!id.startsWith("j_id") || component instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)component).getClientBehaviors().isEmpty());
    }

    protected WidgetBuilder getWidgetBuilder(FacesContext context) {
        return PrimeRequestContext.getCurrentInstance(context).getWidgetBuilder();
    }

    protected StyleClassBuilder getStyleClassBuilder(FacesContext context) {
        return PrimeRequestContext.getCurrentInstance(context).getStyleClassBuilder();
    }

    protected StyleBuilder getStyleBuilder(FacesContext context) {
        return PrimeRequestContext.getCurrentInstance(context).getStyleBuilder();
    }

    protected void renderValidationMetadata(FacesContext context, EditableValueHolder component) throws IOException {
        Validator[] validators;
        BeanValidationMetadata beanValidationMetadata;
        PrimeApplicationContext applicationContext;
        Converter converter;
        if (!PrimeApplicationContext.getCurrentInstance(context).getConfig().isClientSideValidationEnabled()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        UIComponent comp = (UIComponent)component;
        try {
            converter = ComponentUtils.getConverter(context, comp);
        }
        catch (PropertyNotFoundException e) {
            String message = "Skip rendering of CSV metadata for component \"" + comp.getClientId(context) + "\" because the ValueExpression of the \"value\" attribute isn't resolvable completely (e.g. a sub-expression returns null)";
            LOGGER.log(Level.FINE, message);
            return;
        }
        Map attrs = comp.getAttributes();
        Object label = attrs.get("label");
        Object requiredMessage = attrs.get("requiredMessage");
        Object validatorMessage = attrs.get("validatorMessage");
        Object converterMessage = attrs.get("converterMessage");
        ArrayList<String> validatorIds = null;
        String highlighter = this.getHighlighter();
        if (label != null) {
            writer.writeAttribute("data-p-label", label, null);
        }
        if (requiredMessage != null) {
            writer.writeAttribute("data-p-rmsg", requiredMessage, null);
        }
        if (validatorMessage != null) {
            writer.writeAttribute("data-p-vmsg", validatorMessage, null);
        }
        if (converterMessage != null) {
            writer.writeAttribute("data-p-cmsg", converterMessage, null);
        }
        if (converter instanceof ClientConverter) {
            ClientConverter clientConverter = (ClientConverter)converter;
            Map<String, Object> metadata = clientConverter.getMetadata();
            writer.writeAttribute("data-p-con", (Object)((ClientConverter)converter).getConverterId(), null);
            if (metadata != null && !metadata.isEmpty()) {
                this.renderValidationMetadataMap(context, metadata);
            }
        }
        if ((applicationContext = PrimeApplicationContext.getCurrentInstance(context)).getConfig().isBeanValidationEnabled() && (beanValidationMetadata = BeanValidationMetadataMapper.resolveValidationMetadata(context, comp, applicationContext)) != null) {
            if (beanValidationMetadata.getAttributes() != null) {
                this.renderValidationMetadataMap(context, beanValidationMetadata.getAttributes());
            }
            if (beanValidationMetadata.getValidatorIds() != null) {
                if (validatorIds == null) {
                    validatorIds = new ArrayList<String>();
                }
                validatorIds.addAll(beanValidationMetadata.getValidatorIds());
            }
        }
        if (component.isRequired()) {
            writer.writeAttribute("data-p-required", (Object)"true", null);
        }
        if ((validators = component.getValidators()) != null) {
            for (Validator validator : validators) {
                if (!(validator instanceof ClientValidator)) continue;
                ClientValidator clientValidator = (ClientValidator)validator;
                if (validatorIds == null) {
                    validatorIds = new ArrayList();
                }
                validatorIds.add(clientValidator.getValidatorId());
                Map<String, Object> metadata = clientValidator.getMetadata();
                if (metadata == null || metadata.isEmpty()) continue;
                this.renderValidationMetadataMap(context, metadata);
            }
        }
        this.renderValidatorIds(context, validatorIds);
        if (highlighter != null) {
            writer.writeAttribute("data-p-hl", (Object)highlighter, null);
        }
        if (this.isGrouped()) {
            writer.writeAttribute("data-p-grouped", (Object)"true", null);
        }
    }

    private void renderValidationMetadataMap(FacesContext context, Map<String, Object> metadata) throws IOException {
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            writer.writeAttribute(key, value, null);
        }
    }

    private void renderValidatorIds(FacesContext context, List<String> validatorIds) throws IOException {
        if (validatorIds == null || validatorIds.isEmpty()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        StringBuilder builder = SharedStringBuilder.get(context, SB_RENDER_VALIDATOR_IDS);
        for (int i = 0; i < validatorIds.size(); ++i) {
            if (i != 0) {
                builder.append(',');
            }
            String validatorId = validatorIds.get(i);
            builder.append(validatorId);
        }
        writer.writeAttribute("data-p-val", (Object)builder.toString(), null);
    }

    protected String getHighlighter() {
        return null;
    }

    protected boolean isGrouped() {
        return false;
    }

    protected void renderDummyMarkup(FacesContext context, UIComponent component, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("style", (Object)"display: none;", null);
        this.renderPassThruAttributes(context, component, new List[0]);
        writer.endElement("div");
    }

    protected boolean endsWithLenghtUnit(String val) {
        return val.endsWith("px") || val.endsWith("%") || val.endsWith("cm") || val.endsWith("mm") || val.endsWith("in") || val.endsWith("pt") || val.endsWith("pc") || val.endsWith("em") || val.endsWith("ex") || val.endsWith("ch") || val.endsWith("rem") || val.endsWith("vw") || val.endsWith("vh") || val.endsWith("vmin") || val.endsWith("vmax");
    }
}

