/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UIData;
import org.primefaces.component.paginator.CurrentPageReportRenderer;
import org.primefaces.component.paginator.FirstPageLinkRenderer;
import org.primefaces.component.paginator.JumpToPageDropdownRenderer;
import org.primefaces.component.paginator.JumpToPageInputRenderer;
import org.primefaces.component.paginator.LastPageLinkRenderer;
import org.primefaces.component.paginator.NextPageLinkRenderer;
import org.primefaces.component.paginator.PageLinksRenderer;
import org.primefaces.component.paginator.PaginatorElementRenderer;
import org.primefaces.component.paginator.PrevPageLinkRenderer;
import org.primefaces.component.paginator.RowsPerPageDropdownRenderer;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.WidgetBuilder;

public class DataRenderer
extends CoreRenderer {
    private static final Map<String, PaginatorElementRenderer> PAGINATOR_ELEMENTS = MapBuilder.builder().put("{CurrentPageReport}", new CurrentPageReportRenderer()).put("{FirstPageLink}", (CurrentPageReportRenderer)((Object)new FirstPageLinkRenderer())).put("{PreviousPageLink}", (CurrentPageReportRenderer)((Object)new PrevPageLinkRenderer())).put("{NextPageLink}", (CurrentPageReportRenderer)((Object)new NextPageLinkRenderer())).put("{LastPageLink}", (CurrentPageReportRenderer)((Object)new LastPageLinkRenderer())).put("{PageLinks}", (CurrentPageReportRenderer)((Object)new PageLinksRenderer())).put("{RowsPerPageDropdown}", (CurrentPageReportRenderer)((Object)new RowsPerPageDropdownRenderer())).put("{JumpToPageDropdown}", (CurrentPageReportRenderer)((Object)new JumpToPageDropdownRenderer())).put("{JumpToPageInput}", (CurrentPageReportRenderer)((Object)new JumpToPageInputRenderer())).build();

    public static void addPaginatorElement(String element, PaginatorElementRenderer renderer) {
        PAGINATOR_ELEMENTS.put(element, renderer);
    }

    public static PaginatorElementRenderer removePaginatorElement(String element) {
        return PAGINATOR_ELEMENTS.remove(element);
    }

    protected void encodePaginatorMarkup(FacesContext context, Pageable pageable, String position) throws IOException {
        String[] elements;
        if (!pageable.isPaginatorAlwaysVisible() && pageable.getPageCount() <= 1) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean isTop = "top".equals(position);
        UIComponent leftTopContent = pageable.getFacet("paginatorTopLeft");
        UIComponent rightTopContent = pageable.getFacet("paginatorTopRight");
        UIComponent leftBottomContent = pageable.getFacet("paginatorBottomLeft");
        UIComponent rightBottomContent = pageable.getFacet("paginatorBottomRight");
        String styleClass = isTop ? "ui-paginator ui-paginator-top ui-widget-header" : "ui-paginator ui-paginator-bottom ui-widget-header";
        String id = pageable.getClientId(context) + "_paginator_" + position;
        if (!isTop && pageable.getFooter() == null) {
            styleClass = styleClass + " ui-corner-bottom";
        } else if (isTop && pageable.getHeader() == null) {
            styleClass = styleClass + " ui-corner-top";
        }
        String ariaMessage = MessageFactory.getMessage("primefaces.paginator.aria.HEADER", new Object[0]);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"navigation", null);
        writer.writeAttribute("aria-label", (Object)ariaMessage, null);
        if (isTop && ComponentUtils.shouldRenderFacet(leftTopContent)) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-paginator-top-left-content", null);
            this.renderChild(context, leftTopContent);
            writer.endElement("div");
        }
        if (isTop && ComponentUtils.shouldRenderFacet(rightTopContent)) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-paginator-top-right-content", null);
            this.renderChild(context, rightTopContent);
            writer.endElement("div");
        }
        for (String element : elements = pageable.getPaginatorTemplate().split(" ")) {
            PaginatorElementRenderer renderer = PAGINATOR_ELEMENTS.get(element);
            if (renderer != null) {
                renderer.render(context, pageable);
                continue;
            }
            if (element.startsWith("{") && element.endsWith("}")) {
                UIComponent elementFacet = pageable.getFacet(element);
                if (elementFacet == null) continue;
                elementFacet.encodeAll(context);
                continue;
            }
            writer.write(element + " ");
        }
        if (!isTop && ComponentUtils.shouldRenderFacet(leftBottomContent)) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-paginator-bottom-left-content", null);
            this.renderChild(context, leftBottomContent);
            writer.endElement("div");
        }
        if (!isTop && ComponentUtils.shouldRenderFacet(rightBottomContent)) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-paginator-bottom-right-content", null);
            this.renderChild(context, rightBottomContent);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected void encodePaginatorConfig(FacesContext context, Pageable pageable, WidgetBuilder wb) throws IOException {
        String clientId = pageable.getClientId(context);
        String paginatorPosition = pageable.getPaginatorPosition();
        String paginatorContainers = null;
        String currentPageTemplate = pageable.getCurrentPageReportTemplate();
        paginatorContainers = "both".equalsIgnoreCase(paginatorPosition) ? "'" + clientId + "_paginator_top','" + clientId + "_paginator_bottom'" : "'" + clientId + "_paginator_" + paginatorPosition + "'";
        wb.append(",paginator:{").append("id:[").append(paginatorContainers).append("]").append(",rows:").append(pageable.getRows()).append(",rowCount:").append(pageable.getRowCount()).append(",page:").append(pageable.getPage());
        if (currentPageTemplate != null) {
            String currentPageTemplateTmp = currentPageTemplate.replace("'", "\\'");
            wb.append(",currentPageTemplate:'").append(currentPageTemplateTmp).append("'");
        }
        if (pageable.getPageLinks() != 10) {
            wb.append(",pageLinks:").append(pageable.getPageLinks());
        }
        if (!pageable.isPaginatorAlwaysVisible()) {
            wb.append(",alwaysVisible:false");
        }
        wb.append("}");
    }

    public void encodeFacet(FacesContext context, UIData data, String facet, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent component = data.getFacet(facet);
        if (ComponentUtils.shouldRenderFacet(component)) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            component.encodeAll(context);
            writer.endElement("div");
        }
    }

    protected String getHeaderLabel(FacesContext context, UIColumn column) {
        UIComponent header;
        String ariaHeaderText = column.getAriaHeaderText();
        if (ariaHeaderText == null) {
            ariaHeaderText = column.getHeaderText();
        }
        if (ariaHeaderText == null && ComponentUtils.shouldRenderFacet(header = column.getFacet("header"))) {
            if (header instanceof UIPanel) {
                for (UIComponent child : header.getChildren()) {
                    String value;
                    if (!child.isRendered() || (value = ComponentUtils.getValueToRender(context, child)) == null) continue;
                    ariaHeaderText = value;
                    break;
                }
            } else {
                ariaHeaderText = ComponentUtils.getValueToRender(context, header);
            }
        }
        return ariaHeaderText;
    }
}

