/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.text.DecimalFormat;
import org.primefaces.util.BigDecimalValidator;

public class CurrencyValidator
extends BigDecimalValidator {
    public static final char CURRENCY_SYMBOL = '\u00a4';
    public static final String CURRENCY_SYMBOL_STR = Character.toString('\u00a4');
    private static final long serialVersionUID = -4201640771171486514L;
    private static final CurrencyValidator VALIDATOR = new CurrencyValidator();
    private static final char NON_BREAKING_SPACE = '\u00a0';
    private static final String NON_BREAKING_SPACE_STR = Character.toString('\u00a0');

    public static CurrencyValidator getInstance() {
        return VALIDATOR;
    }

    @Override
    protected Number parse(String value, DecimalFormat formatter) {
        Number parsedValue;
        if (value.indexOf(164) >= 0) {
            value = value.replace(CURRENCY_SYMBOL_STR, formatter.getDecimalFormatSymbols().getCurrencySymbol());
        }
        if (formatter.getPositivePrefix().indexOf(160) >= 0) {
            value = value.replaceAll(" ", NON_BREAKING_SPACE_STR);
        }
        if ((parsedValue = super.parse(value, formatter)) != null) {
            return parsedValue;
        }
        String pattern = formatter.toPattern();
        if (pattern.indexOf(164) >= 0) {
            StringBuilder buffer = new StringBuilder(pattern.length());
            for (int i = 0; i < pattern.length(); ++i) {
                if (pattern.charAt(i) == '\u00a4') continue;
                buffer.append(pattern.charAt(i));
            }
            DecimalFormat copyFormatter = (DecimalFormat)formatter.clone();
            copyFormatter.applyPattern(buffer.toString());
            parsedValue = super.parse(value, copyFormatter);
        }
        return parsedValue;
    }
}

