/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.context.FacesContext;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;

public class StyleClassBuilder {
    private static final String KEY = StyleClassBuilder.class.getName() + "#styleClass";
    private final StringBuilder sb;

    public StyleClassBuilder(FacesContext context) {
        this.sb = SharedStringBuilder.get(context, KEY);
    }

    public StyleClassBuilder add(boolean condition, String styleClass) {
        if (condition) {
            if (this.sb.length() != 0) {
                this.sb.append(" ");
            }
            this.sb.append(styleClass);
        }
        return this;
    }

    public StyleClassBuilder add(boolean condition, String styleClass, String notStyleClass) {
        return this.add(condition, styleClass).add(!condition, notStyleClass);
    }

    public StyleClassBuilder add(String styleClass) {
        return this.add(LangUtils.isNotBlank(styleClass), styleClass);
    }

    public StyleClassBuilder add(String defaultStyleClass, String userStyleClass) {
        return this.add(defaultStyleClass).add(userStyleClass);
    }

    public StyleClassBuilder addOrElse(String styleClass, String fallback) {
        if (LangUtils.isNotBlank(styleClass)) {
            return this.add(true, styleClass);
        }
        return this.add(fallback);
    }

    public String build() {
        String styleClass = this.sb.toString();
        this.sb.setLength(0);
        return styleClass;
    }
}

