/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.cascadeselect;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.primefaces.component.cascadeselect.CascadeSelect;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class CascadeSelectRenderer
extends SelectOneRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object renderer = ComponentUtils.getUnwrappedRenderer(context, "javax.faces.SelectOne", "javax.faces.Listbox");
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CascadeSelect cascadeSelect = (CascadeSelect)component;
        this.encodeMarkup(context, cascadeSelect);
        this.encodeScript(context, cascadeSelect);
    }

    protected void encodeMarkup(FacesContext context, CascadeSelect cascadeSelect) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = cascadeSelect.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)cascadeSelect);
        String style = cascadeSelect.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-cascadeselect ui-widget ui-state-default ui-corner-all").add(cascadeSelect.isDisabled(), "ui-state-disabled").add(cascadeSelect.getStyleClass()).build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.renderARIACombobox(context, (UIInput)cascadeSelect);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)cascadeSelect);
        this.encodeInput(context, cascadeSelect, valueToRender);
        this.encodeLabel(context, cascadeSelect, selectItems, valueToRender);
        this.encodeTrigger(context);
        this.encodePanel(context, cascadeSelect, selectItems);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, CascadeSelect cascadeSelect, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = cascadeSelect.getInputClientId();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("tabindex", (Object)cascadeSelect.getTabindex(), null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)cascadeSelect);
        this.renderDomEvents(context, (UIComponent)cascadeSelect, HTML.BLUR_FOCUS_EVENTS);
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeLabel(FacesContext context, CascadeSelect cascadeSelect, List<SelectItem> itemList, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = ComponentUtils.getConverter(context, (UIComponent)cascadeSelect);
        String itemLabel = valueToRender;
        SelectItem foundItem = this.findSelectItemByValue(context, (UIComponent)cascadeSelect, converter, itemList, valueToRender);
        if (foundItem != null) {
            itemLabel = foundItem.getLabel();
        }
        String placeholder = LangUtils.isNotBlank(itemLabel) ? itemLabel : cascadeSelect.getPlaceholder();
        String styleClass = this.getStyleClassBuilder(context).add(placeholder != null, "ui-cascadeselect-label ui-inputfield ui-corner-all").add(placeholder == null, "ui-cascadeselect-label-empty").build();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (LangUtils.isNotBlank(placeholder)) {
            writer.writeText((Object)placeholder, null);
        }
        writer.endElement("span");
    }

    protected void encodeTrigger(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-cascadeselect-trigger", null);
        writer.writeAttribute("role", (Object)"button", null);
        writer.writeAttribute("aria-haspopup", (Object)"listbox", null);
        writer.writeAttribute("aria-expanded", (Object)"false", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-cascadeselect-trigger-icon ui-icon pi pi-chevron-down", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodePanel(FacesContext context, CascadeSelect cascadeSelect, List<SelectItem> itemList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String panelId = cascadeSelect.getPanelClientId();
        SelectItem[] items = itemList == null ? null : itemList.toArray(new SelectItem[itemList.size()]);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)panelId, null);
        writer.writeAttribute("class", (Object)"ui-cascadeselect-panel ui-widget ui-widget-content ui-corner-all ui-helper-hidden ui-shadow ui-input-overlay", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-cascadeselect-items-wrapper", null);
        this.encodeList(context, cascadeSelect, items, false);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, CascadeSelect cascadeSelect, SelectItem[] items, boolean isSublist) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = isSublist ? "ui-cascadeselect-panel ui-cascadeselect-items ui-cascadeselect-sublist" : "ui-cascadeselect-panel ui-cascadeselect-items";
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"listbox", null);
        writer.writeAttribute("aria-orientation", (Object)"horizontal", null);
        this.renderARIARequired(context, (UIInput)cascadeSelect);
        this.encodeListItems(context, cascadeSelect, items);
        writer.endElement("ul");
    }

    protected void encodeListItems(FacesContext context, CascadeSelect cascadeSelect, SelectItem[] selectItems) throws IOException {
        if (selectItems != null && selectItems.length > 0) {
            ResponseWriter writer = context.getResponseWriter();
            UIComponent contentFacet = cascadeSelect.getFacet("content");
            Converter converter = ComponentUtils.getConverter(context, (UIComponent)cascadeSelect);
            String var = cascadeSelect.getVar();
            for (SelectItem selectItem : selectItems) {
                SelectItemGroup group;
                SelectItem[] groupItems;
                boolean isGroup = selectItem instanceof SelectItemGroup;
                Object itemValue = selectItem.getValue();
                String itemLabel = selectItem.getLabel();
                String itemValueAsString = this.getOptionAsString(context, (UIComponent)cascadeSelect, converter, selectItem.getValue());
                String itemStyleClass = this.getStyleClassBuilder(context).add("ui-cascadeselect-item").add(isGroup, "ui-cascadeselect-item-group").build();
                if (var != null) {
                    context.getExternalContext().getRequestMap().put(var, itemValue);
                }
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)itemStyleClass, null);
                writer.writeAttribute("data-value", (Object)itemValueAsString, null);
                writer.writeAttribute("data-label", (Object)itemLabel, null);
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-cascadeselect-item-content", null);
                writer.writeAttribute("tabindex", (Object)"0", null);
                if (ComponentUtils.shouldRenderFacet(contentFacet)) {
                    contentFacet.encodeAll(context);
                } else {
                    writer.startElement("span", (UIComponent)cascadeSelect);
                    writer.writeAttribute("class", (Object)"ui-cascadeselect-item-text", null);
                    writer.writeText((Object)itemLabel, null);
                    writer.endElement("span");
                }
                if (isGroup) {
                    writer.startElement("span", (UIComponent)cascadeSelect);
                    writer.writeAttribute("class", (Object)"ui-cascadeselect-group-icon ui-icon pi pi-angle-right", null);
                    writer.endElement("span");
                }
                writer.endElement("div");
                if (isGroup && (groupItems = (group = (SelectItemGroup)selectItem).getSelectItems()) != null && groupItems.length > 0) {
                    this.encodeList(context, cascadeSelect, group.getSelectItems(), true);
                }
                writer.endElement("li");
            }
            if (var != null) {
                context.getExternalContext().getRequestMap().put(var, null);
            }
        }
    }

    protected void encodeScript(FacesContext context, CascadeSelect cascadeSelect) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("CascadeSelect", cascadeSelect).attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)cascadeSelect, cascadeSelect.getAppendTo(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE), null);
        this.encodeClientBehaviors(context, cascadeSelect);
        wb.finish();
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context) + "_input";
    }
}

