/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.export;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.TableExporter;
import org.primefaces.model.LazyDataModel;

public abstract class DataTableExporter
extends TableExporter<DataTable> {
    private OutputStream outputStream;

    protected boolean hasColumnFooter(List<UIColumn> columns) {
        return columns.stream().anyMatch(c -> c.getFooter() != null);
    }

    protected String exportColumnByFunction(FacesContext context, org.primefaces.component.api.UIColumn column) {
        MethodExpression exportFunction = column.getExportFunction();
        if (exportFunction != null) {
            return (String)exportFunction.invoke(context.getELContext(), new Object[]{column});
        }
        return "";
    }

    protected void exportPageOnly(FacesContext context, DataTable table, Object document) {
        int first = table.getFirst();
        int rows = table.getRows();
        if (rows == 0) {
            rows = table.getRowCount();
        }
        int rowsToExport = first + rows;
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(table, document, rowIndex);
        }
    }

    protected void exportAll(FacesContext context, DataTable table, Object document) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            LazyDataModel lazyDataModel = (LazyDataModel)table.getValue();
            Object wrappedData = lazyDataModel.getWrappedData();
            if (rowCount > 0) {
                table.setFirst(0);
                table.setRows(rowCount);
                table.loadLazyDataIfEnabled();
            }
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, document, rowIndex);
            }
            table.setFirst(first);
            table.setRows(rows);
            table.setRowIndex(-1);
            lazyDataModel.setWrappedData(wrappedData);
            lazyDataModel.setPageSize(rows);
            lazyDataModel.setRowIndex(-1);
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, document, rowIndex);
            }
            table.setFirst(first);
        }
    }

    protected void exportRow(DataTable table, Object document, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.preRowExport(table, document);
        this.exportCells(table, document);
        this.postRowExport(table, document);
    }

    protected void exportRow(DataTable table, Object document) {
        this.preRowExport(table, document);
        this.exportCells(table, document);
        this.postRowExport(table, document);
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, Object document) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportRow(table, document);
                }
            } else if (Collection.class.isAssignableFrom(selection.getClass())) {
                for (Object obj : (Collection)selection) {
                    requestMap.put(var, obj);
                    this.exportRow(table, document);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, document);
            }
        }
    }

    protected void preExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
    }

    protected void postExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
    }

    protected void preRowExport(DataTable table, Object document) {
    }

    protected void postRowExport(DataTable table, Object document) {
    }

    protected abstract void exportCells(DataTable var1, Object var2);

    @Override
    public void export(FacesContext context, List<DataTable> tables, OutputStream outputStream, ExportConfiguration exportConfiguration) throws IOException {
        this.outputStream = outputStream;
        this.preExport(context, exportConfiguration);
        ExportVisitCallback exportCallback = new ExportVisitCallback(tables, exportConfiguration);
        exportCallback.export(context);
        this.postExport(context, exportConfiguration);
        this.outputStream = null;
    }

    protected abstract void doExport(FacesContext var1, DataTable var2, ExportConfiguration var3, int var4) throws IOException;

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    private class ExportVisitCallback
    implements VisitCallback {
        private ExportConfiguration config;
        private List<DataTable> tables;
        private int index;

        public ExportVisitCallback(List<DataTable> tables, ExportConfiguration config) {
            this.tables = tables;
            this.config = config;
            this.index = 0;
        }

        public VisitResult visit(VisitContext context, UIComponent component) {
            try {
                DataTableExporter.this.doExport(context.getFacesContext(), (DataTable)component, this.config, this.index);
                ++this.index;
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            return VisitResult.ACCEPT;
        }

        public void export(FacesContext context) {
            List tableIds = this.tables.stream().map(dt -> dt.getClientId(context)).collect(Collectors.toList());
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, tableIds, null);
            context.getViewRoot().visitTree(visitContext, (VisitCallback)this);
        }
    }

    protected static enum ColumnType {
        HEADER("header"),
        FOOTER("footer");

        private final String facet;

        private ColumnType(String facet) {
            this.facet = facet;
        }

        public String facet() {
            return this.facet;
        }

        public String toString() {
            return this.facet;
        }
    }
}

