/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.export;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.export.DataTableExporter;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;

public class DataTableXMLExporter
extends DataTableExporter {
    @Override
    public void doExport(FacesContext context, DataTable table, ExportConfiguration exportConfiguration, int index) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(this.getOutputStream(), exportConfiguration.getEncodingType());
             PrintWriter writer = new PrintWriter(osw);){
            if (exportConfiguration.getPreProcessor() != null) {
                exportConfiguration.getPreProcessor().invoke(context.getELContext(), new Object[]{writer});
            }
            String doctag = table.getExportTag() != null ? table.getExportTag() : table.getId();
            writer.append("<?xml version=\"1.0\"?>\n");
            writer.append("<" + doctag + ">\n");
            if (exportConfiguration.isPageOnly()) {
                this.exportPageOnly(context, table, writer);
            } else if (exportConfiguration.isSelectionOnly()) {
                this.exportSelectionOnly(context, table, writer);
            } else {
                this.exportAll(context, table, writer);
            }
            writer.append("</" + doctag + ">");
            table.setRowIndex(-1);
            if (exportConfiguration.getPostProcessor() != null) {
                exportConfiguration.getPostProcessor().invoke(context.getELContext(), new Object[]{writer});
            }
            writer.flush();
        }
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public String getFileExtension() {
        return ".xml";
    }

    @Override
    protected void preRowExport(DataTable table, Object document) {
        String rowtag = table.getExportRowTag() != null ? table.getExportRowTag() : table.getVar();
        ((PrintWriter)document).append("\t<" + rowtag + ">\n");
    }

    @Override
    protected void postRowExport(DataTable table, Object document) {
        String rowtag = table.getExportRowTag() != null ? table.getExportRowTag() : table.getVar();
        ((PrintWriter)document).append("\t</" + rowtag + ">\n");
    }

    @Override
    protected void exportCells(DataTable table, Object document) {
        PrintWriter writer = (PrintWriter)document;
        for (UIColumn col : this.getExportableColumns(table)) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            String columnTag = this.getColumnTag(col);
            try {
                this.addColumnValue(writer, table, col.getChildren(), columnTag, col);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }

    protected String getColumnTag(UIColumn column) {
        String columnTag;
        String headerText = column.getExportTag();
        if (LangUtils.isBlank(headerText)) {
            headerText = column.getExportHeaderValue() != null ? column.getExportHeaderValue() : column.getHeaderText();
        }
        UIComponent facet = column.getFacet("header");
        if (headerText != null) {
            columnTag = headerText.toLowerCase();
        } else if (ComponentUtils.shouldRenderFacet(facet)) {
            columnTag = this.exportValue(FacesContext.getCurrentInstance(), facet).toLowerCase();
        } else {
            throw new FacesException("No suitable xml tag found for " + column);
        }
        return EscapeUtils.forXmlTag(columnTag);
    }

    protected void addColumnValue(PrintWriter writer, DataTable table, List<UIComponent> components, String tag, UIColumn column) throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        writer.append("\t\t<" + tag + ">");
        this.exportColumn(context, table, column, components, false, s -> writer.append(EscapeUtils.forXml(s)));
        writer.append("</" + tag + ">\n");
    }
}

