/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UITable;
import org.primefaces.component.export.Exporter;
import org.primefaces.model.ColumnMeta;
import org.primefaces.util.LangUtils;

public abstract class TableExporter<T extends UIComponent>
extends Exporter<T> {
    private Map<UITable, List<UIColumn>> exportableColumns = new HashMap<UITable, List<UIColumn>>();

    protected void exportColumn(FacesContext context, T table, UIColumn column, List<UIComponent> components, boolean joinComponents, Consumer<String> callback) {
        if (column.getExportValue() != null) {
            callback.accept(column.getExportValue());
        } else if (column.getExportFunction() != null) {
            MethodExpression exportFunction = column.getExportFunction();
            callback.accept((String)exportFunction.invoke(context.getELContext(), new Object[]{column}));
        } else if (LangUtils.isNotBlank(column.getField())) {
            String value = ((UITable)table).getConvertedFieldValue(context, column);
            callback.accept(Objects.toString(value, ""));
        } else {
            StringBuilder sb = null;
            for (UIComponent component : components) {
                if (!component.isRendered()) continue;
                String value = this.exportValue(context, component);
                if (joinComponents) {
                    if (value == null) continue;
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(value);
                    continue;
                }
                callback.accept(value);
            }
            if (joinComponents) {
                callback.accept(sb == null ? null : sb.toString());
            }
        }
    }

    protected List<UIColumn> getExportableColumns(UITable table) {
        if (this.exportableColumns.containsKey(table)) {
            return this.exportableColumns.get(table);
        }
        int allColumnsSize = table.getColumns().size();
        ArrayList<UIColumn> exportcolumns = new ArrayList<UIColumn>(allColumnsSize);
        boolean visibleColumnsOnly = this.getExportConfiguration().isVisibleOnly();
        AtomicBoolean hasNonDefaultSortPriorities = new AtomicBoolean(false);
        ArrayList<ColumnMeta> visibleColumnMetadata = new ArrayList<ColumnMeta>(allColumnsSize);
        Map<String, ColumnMeta> allColumnMeta = table.getColumnMeta();
        table.forEachColumn(true, true, true, column -> {
            if (column.isExportable()) {
                String columnKey = column.getColumnKey();
                ColumnMeta currentMeta = (ColumnMeta)allColumnMeta.get(columnKey);
                if (!visibleColumnsOnly || visibleColumnsOnly && (currentMeta == null || currentMeta.getVisible().booleanValue())) {
                    int displayPriority = column.getDisplayPriority();
                    ColumnMeta metaCopy = new ColumnMeta(columnKey);
                    metaCopy.setDisplayPriority(displayPriority);
                    visibleColumnMetadata.add(metaCopy);
                    if (displayPriority != 0) {
                        hasNonDefaultSortPriorities.set(true);
                    }
                }
            }
            return true;
        });
        if (hasNonDefaultSortPriorities.get()) {
            Comparator sortIntegersNaturallyWithNullsLast = Comparator.nullsLast(Comparator.naturalOrder());
            visibleColumnMetadata.sort(Comparator.comparing(ColumnMeta::getDisplayPriority, sortIntegersNaturallyWithNullsLast));
        }
        for (ColumnMeta meta : visibleColumnMetadata) {
            String metaColumnKey = meta.getColumnKey();
            table.invokeOnColumn(metaColumnKey, -1, column -> exportcolumns.add((UIColumn)column));
        }
        this.exportableColumns.put(table, exportcolumns);
        return exportcolumns;
    }
}

