/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.focus;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.focus.Focus;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.RendererUtils;

public class FocusRenderer
extends CoreRenderer {
    private static final Map<String, Integer> SEVERITY_ORDINALS = new HashMap<String, Integer>();

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Focus focus = (Focus)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)focus);
        writer.writeAttribute("id", (Object)focus.getClientId(context), "id");
        writer.endElement("span");
        writer.startElement("script", (UIComponent)focus);
        RendererUtils.encodeScriptTypeIfNecessary(context);
        if (this.isValueBlank(focus.getFor())) {
            this.encodeImplicitFocus(context, focus);
        } else {
            this.encodeExplicitFocus(context, focus);
        }
        writer.endElement("script");
    }

    protected void encodeExplicitFocus(FacesContext context, Focus focus) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent forComponent = SearchExpressionFacade.resolveComponent(context, (UIComponent)focus, focus.getFor());
        String clientId = forComponent.getClientId(context);
        writer.write("$(function(){");
        writer.write("PrimeFaces.focus('" + clientId + "');");
        writer.write("});");
    }

    protected void encodeImplicitFocus(FacesContext context, Focus focus) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String invalidClientId = this.findFirstInvalidComponentClientId(context, focus);
        writer.write("$(function(){");
        if (invalidClientId != null) {
            writer.write("PrimeFaces.focus('" + invalidClientId + "');");
        } else if (focus.getContext() != null) {
            UIComponent focusContext = SearchExpressionFacade.resolveComponent(context, (UIComponent)focus, focus.getContext());
            writer.write("PrimeFaces.focus(null, '" + focusContext.getClientId(context) + "');");
        } else {
            writer.write("PrimeFaces.focus();");
        }
        writer.write("});");
    }

    protected String findFirstInvalidComponentClientId(FacesContext context, Focus focus) {
        int minSeverityOrdinal = SEVERITY_ORDINALS.get(focus.getMinSeverity());
        Iterator iterator = context.getClientIdsWithMessages();
        while (iterator.hasNext()) {
            String clientId = (String)iterator.next();
            Iterator messageIter = context.getMessages(clientId);
            while (messageIter.hasNext()) {
                FacesMessage message = (FacesMessage)messageIter.next();
                if (message.getSeverity().getOrdinal() < minSeverityOrdinal) continue;
                return clientId;
            }
        }
        return null;
    }

    static {
        SEVERITY_ORDINALS.put("info", FacesMessage.SEVERITY_INFO.getOrdinal());
        SEVERITY_ORDINALS.put("warn", FacesMessage.SEVERITY_WARN.getOrdinal());
        SEVERITY_ORDINALS.put("error", FacesMessage.SEVERITY_ERROR.getOrdinal());
        SEVERITY_ORDINALS.put("fatal", FacesMessage.SEVERITY_FATAL.getOrdinal());
    }
}

