/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.mindmap;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.mindmap.Mindmap;
import org.primefaces.model.mindmap.MindmapNode;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class MindmapRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Mindmap map = (Mindmap)component;
        if (map.isNodeSelectRequest(context)) {
            MindmapNode node = map.getSelectedNode();
            this.encodeNode(context, map, node, map.getSelectedNodeKey(context));
        } else {
            this.encodeMarkup(context, map);
            this.encodeScript(context, map);
        }
    }

    protected void encodeScript(FacesContext context, Mindmap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MindmapNode root = map.getValue();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Mindmap", map).attr("effectSpeed", map.getEffectSpeed());
        if (root != null) {
            writer.write(",model:");
            this.encodeNode(context, map, root, "root");
        }
        this.encodeClientBehaviors(context, map);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Mindmap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = map.getClientId(context);
        String style = map.getStyle();
        String styleClass = map.getStyleClass();
        styleClass = styleClass == null ? "ui-mindmap ui-widget ui-widget-content ui-corner-all" : "ui-mindmap ui-widget ui-widget-content ui-corner-all " + styleClass;
        writer.startElement("div", (UIComponent)map);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.endElement("div");
    }

    protected void encodeNode(FacesContext context, Mindmap map, MindmapNode node, String nodeKey) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<MindmapNode> children = node.getChildren();
        MindmapNode parent = node.getParent();
        writer.write("{");
        this.encodeNodeConfig(context, map, node, nodeKey);
        if (parent != null) {
            String parentNodeKey = nodeKey.indexOf(95) != -1 ? nodeKey.substring(0, nodeKey.lastIndexOf(95)) : "root";
            writer.write(",\"parent\":{");
            this.encodeNodeConfig(context, map, parent, parentNodeKey);
            writer.write("}");
        }
        if (!children.isEmpty()) {
            int size = children.size();
            writer.write(",\"children\":[");
            for (int i = 0; i < size; ++i) {
                String childKey = "root".equals(nodeKey) ? String.valueOf(i) : nodeKey + "_" + i;
                MindmapNode child = children.get(i);
                this.encodeNode(context, map, child, childKey);
                if (i == size - 1) continue;
                writer.write(",");
            }
            writer.write("]");
        }
        writer.write("}");
    }

    protected void encodeNodeConfig(FacesContext context, Mindmap map, MindmapNode node, String nodeKey) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write("\"label\":\"" + node.getLabel() + "\"");
        if (nodeKey != null) {
            writer.write(",\"key\":\"" + nodeKey + "\"");
        }
        if (node.getFill() != null) {
            writer.write(",\"fill\":\"" + node.getFill() + "\"");
        }
        if (node.isSelectable()) {
            writer.write(",\"selectable\":true");
        }
    }
}

