/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.remotecommand;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.remotecommand.RemoteCommand;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.CSVBuilder;

public class RemoteCommandRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        RemoteCommand command = (RemoteCommand)component;
        if (context.getExternalContext().getRequestParameterMap().containsKey(command.getClientId(context))) {
            ActionEvent event = new ActionEvent((UIComponent)command);
            if (command.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            command.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RemoteCommand command = (RemoteCommand)component;
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance(context);
        boolean csvEnabled = requestContext.getApplicationContext().getConfig().isClientSideValidationEnabled() && command.isValidateClient();
        ResponseWriter writer = context.getResponseWriter();
        String clientId = command.getClientId(context);
        String name = this.resolveName(command, context);
        String request = this.preConfiguredAjaxRequestBuilder(context, command).passParams().build();
        if (csvEnabled) {
            CSVBuilder csvb = requestContext.getCSVBuilder();
            request = csvb.init().source("this").ajax(true).process((UIComponent)command, command.getProcess()).update((UIComponent)command, command.getUpdate()).command("return " + request).build();
        } else {
            request = "return " + request;
        }
        writer.startElement("script", (UIComponent)command);
        writer.writeAttribute("id", (Object)clientId, null);
        RendererUtils.encodeScriptTypeIfNecessary(context);
        writer.write(name + " = function() {");
        writer.write(request);
        writer.write("}");
        if (command.isAutoRun()) {
            writer.write(";$(function() {");
            writer.write(name + "();");
            writer.write("});");
        }
        writer.endElement("script");
    }

    protected String resolveName(RemoteCommand command, FacesContext context) {
        String userName = command.getName();
        if (userName != null) {
            return userName;
        }
        return "command_" + command.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }
}

