/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectonelistbox;

import java.io.IOException;
import java.util.List;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.component.column.Column;
import org.primefaces.component.selectonelistbox.SelectOneListbox;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.WidgetBuilder;

public class SelectOneListboxRenderer
extends SelectOneRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object renderer = ComponentUtils.getUnwrappedRenderer(context, "javax.faces.SelectOne", "javax.faces.Listbox");
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectOneListbox listbox = (SelectOneListbox)component;
        this.encodeMarkup(context, listbox);
        this.encodeScript(context, listbox);
    }

    protected void encodeMarkup(FacesContext context, SelectOneListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = listbox.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)listbox);
        String style = listbox.getStyle();
        String styleClass = this.createStyleClass((UIInput)listbox, "ui-selectonelistbox ui-inputfield ui-widget ui-widget-content ui-corner-all");
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (listbox.isFilter()) {
            this.encodeFilter(context, listbox);
        }
        this.encodeInput(context, listbox, clientId, selectItems);
        this.encodeList(context, listbox, selectItems);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectOneListbox listbox) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectOneListbox", listbox).attr("disabled", listbox.isDisabled(), false);
        if (listbox.isFilter()) {
            wb.attr("filter", true).attr("filterMatchMode", listbox.getFilterMatchMode(), null).nativeAttr("filterFunction", listbox.getFilterFunction(), null).attr("caseSensitive", listbox.isCaseSensitive(), false).attr("filterNormalize", listbox.isFilterNormalize(), false);
        }
        wb.finish();
    }

    protected void encodeInput(FacesContext context, SelectOneListbox listbox, String clientId, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputid = clientId + "_input";
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("select", (UIComponent)listbox);
        writer.writeAttribute("id", (Object)inputid, "id");
        writer.writeAttribute("name", (Object)inputid, null);
        writer.writeAttribute("size", (Object)"2", null);
        this.renderAccessibilityAttributes(context, (UIInput)listbox);
        this.renderPassThruAttributes(context, (UIComponent)listbox, HTML.TAB_INDEX);
        this.renderDomEvents(context, (UIComponent)listbox, SelectOneListbox.DOM_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)listbox);
        this.encodeSelectItems(context, listbox, selectItems);
        writer.endElement("select");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, SelectOneListbox listbox, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = listbox.getConverter();
        Object values = this.getValues((UISelectOne)listbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)listbox);
        boolean customContent = listbox.getVar() != null;
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("class", (Object)"ui-selectlistbox-listcontainer", null);
        writer.writeAttribute("style", (Object)("height:" + this.calculateWrapperHeight(listbox, this.countSelectItems(selectItems))), null);
        if (customContent) {
            writer.startElement("table", null);
            writer.writeAttribute("class", (Object)"ui-selectlistbox-list", null);
            writer.startElement("tbody", null);
            for (int i = 0; i < selectItems.size(); ++i) {
                SelectItem selectItem = selectItems.get(i);
                this.encodeItem(context, listbox, selectItem, values, submittedValues, converter, customContent);
            }
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-selectlistbox-list", null);
            for (int i = 0; i < selectItems.size(); ++i) {
                SelectItem selectItem = selectItems.get(i);
                this.encodeItem(context, listbox, selectItem, values, submittedValues, converter, customContent);
            }
            writer.endElement("ul");
        }
        writer.endElement("div");
    }

    protected void encodeItem(FacesContext context, SelectOneListbox listbox, SelectItem option, Object values, Object submittedValues, Converter converter, boolean customContent) throws IOException {
        Object itemValue;
        Object valuesArray;
        String itemClass;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)listbox, converter, option.getValue());
        boolean disabled = option.isDisabled() || listbox.isDisabled();
        String string = itemClass = disabled ? "ui-selectlistbox-item ui-corner-all ui-state-disabled" : "ui-selectlistbox-item ui-corner-all";
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)listbox, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        if (selected) {
            itemClass = itemClass + " ui-state-highlight";
        }
        if (customContent) {
            String var = listbox.getVar();
            context.getExternalContext().getRequestMap().put(var, option.getValue());
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)itemClass, null);
            if (option.getDescription() != null) {
                writer.writeAttribute("title", (Object)option.getDescription(), null);
            }
            for (UIComponent child : listbox.getChildren()) {
                if (!(child instanceof Column) || !child.isRendered()) continue;
                writer.startElement("td", null);
                writer.startElement("span", null);
                this.renderChildren(context, child);
                writer.endElement("span");
                writer.endElement("td");
            }
            writer.endElement("tr");
        } else {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)itemClass, null);
            writer.startElement("span", null);
            if (option.isEscape()) {
                writer.writeText((Object)option.getLabel(), null);
            } else {
                writer.write(option.getLabel());
            }
            writer.endElement("span");
            writer.endElement("li");
        }
    }

    protected void encodeSelectItems(FacesContext context, SelectOneListbox listbox, List<SelectItem> selectItems) throws IOException {
        Converter converter = listbox.getConverter();
        Object values = this.getValues((UISelectOne)listbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)listbox);
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            this.encodeOption(context, listbox, selectItem, values, submittedValues, converter);
        }
    }

    protected void encodeOption(FacesContext context, SelectOneListbox listbox, SelectItem option, Object values, Object submittedValues, Converter converter) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)listbox, converter, option.getValue());
        boolean bl = disabled = option.isDisabled() || listbox.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)listbox, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("option", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (selected) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("option");
    }

    protected void encodeFilter(FacesContext context, SelectOneListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = listbox.getClientId(context) + "_filter";
        boolean disabled = listbox.isDisabled();
        String filterClass = disabled ? "ui-selectlistbox-filter ui-inputfield ui-widget ui-state-default ui-corner-all ui-state-disabled" : "ui-selectlistbox-filter ui-inputfield ui-widget ui-state-default ui-corner-all";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-selectlistbox-filter-container", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-search", id);
        writer.endElement("span");
        writer.startElement("input", null);
        writer.writeAttribute("class", (Object)filterClass, null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("aria-label", (Object)MessageFactory.getMessage("primefaces.input.aria.filter", new Object[0]), null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected String calculateWrapperHeight(SelectOneListbox listbox, int itemSize) {
        int height = listbox.getScrollHeight();
        if (height != Integer.MAX_VALUE) {
            return height + "px";
        }
        if (itemSize > 10) {
            return "200px";
        }
        return "auto";
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context) + "_input";
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public String getHighlighter() {
        return "listbox";
    }
}

