/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.staticmessage;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.staticmessage.StaticMessage;
import org.primefaces.renderkit.UINotificationRenderer;

public class StaticMessageRenderer
extends UINotificationRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        StaticMessage staticMessage = (StaticMessage)component;
        ResponseWriter writer = context.getResponseWriter();
        String display = staticMessage.getDisplay();
        boolean iconOnly = "icon".equals(display);
        boolean escape = staticMessage.isEscape();
        String summary = staticMessage.getSummary();
        String detail = staticMessage.getDetail();
        String severity = staticMessage.getSeverity();
        severity = severity == null ? "info" : severity.toLowerCase();
        String styleClass = "ui-message ui-staticmessage ui-message-" + severity + " ui-widget ui-corner-all";
        if (iconOnly) {
            styleClass = styleClass + " ui-message-icon-only ui-helper-clearfix";
        }
        if (staticMessage.getStyleClass() != null) {
            styleClass = styleClass + " " + staticMessage.getStyleClass();
        }
        String style = staticMessage.getStyle();
        writer.startElement("div", (UIComponent)staticMessage);
        writer.writeAttribute("id", (Object)staticMessage.getClientId(context), null);
        writer.writeAttribute("aria-live", (Object)"polite", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (!"text".equals(display)) {
            this.encodeIcon(writer, severity, detail, iconOnly);
        }
        if (!iconOnly) {
            this.encodeText(writer, summary, severity + "-summary", escape);
            this.encodeText(writer, detail, severity + "-detail", escape);
        }
        writer.endElement("div");
    }

    protected void encodeText(ResponseWriter writer, String text, String severity, boolean escape) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity), null);
        if (text != null) {
            if (escape) {
                writer.writeText((Object)text, null);
            } else {
                writer.write(text);
            }
        }
        writer.endElement("span");
    }

    protected void encodeIcon(ResponseWriter writer, String severity, String title, boolean iconOnly) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity + "-icon"), null);
        if (iconOnly && title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.endElement("span");
    }
}

