/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.PrimeFaces;
import org.primefaces.component.tree.Tree;
import org.primefaces.component.tree.TreeBase;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.model.TreeNode;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.FilterConstraints;
import org.primefaces.model.filter.FunctionFilterConstraint;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;

public class TreeRenderer
extends CoreRenderer {
    private static final String SB_DECODE_SELECTION = TreeRenderer.class.getName() + "#decodeSelection";

    public void decode(FacesContext context, UIComponent component) {
        Tree tree = (Tree)component;
        TreeNode root = tree.getValue();
        if (tree.isDragDropRequest(context)) {
            this.decodeDragDrop(context, tree, root);
        }
        if (tree.isSelectionEnabled()) {
            this.decodeSelection(context, tree, root);
        }
        this.decodeBehaviors(context, (UIComponent)tree);
    }

    public void decodeSelection(FacesContext context, Tree tree, TreeNode root) {
        String clientId;
        boolean multiple = tree.isMultipleSelectionMode();
        Class<?> selectionType = tree.getSelectionType();
        if (multiple && !selectionType.isArray() && !List.class.isAssignableFrom(selectionType)) {
            throw new FacesException("Multiple selection reference must be an Array or a List for Tree " + tree.getClientId());
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String selection = (String)params.get((clientId = tree.getClientId(context)) + "_selection");
        if (this.isValueBlank(selection)) {
            if (multiple) {
                tree.setSelection(selectionType.isArray() ? new TreeNode[]{} : Collections.emptyList());
            } else {
                tree.setSelection(null);
            }
        } else {
            String[] selectedRowKeys = selection.split(",");
            if (multiple) {
                TreeNode[] selectedNodes = new ArrayList();
                for (int i = 0; i < selectedRowKeys.length; ++i) {
                    tree.setRowKey(root, selectedRowKeys[i]);
                    TreeNode rowNode = tree.getRowNode();
                    if (rowNode == null) continue;
                    selectedNodes.add(rowNode);
                }
                tree.setSelection(selectionType.isArray() ? selectedNodes.toArray(new TreeNode[selectedNodes.size()]) : selectedNodes);
            } else {
                tree.setRowKey(root, selectedRowKeys[0]);
                tree.setSelection(tree.getRowNode());
            }
            tree.setRowKey(root, null);
        }
        if (tree.isCheckboxSelectionMode() && tree.isDynamic() && tree.isSelectionRequest(context) && tree.isPropagateSelectionDown()) {
            String selectedNodeRowKey = (String)params.get(clientId + "_instantSelection");
            tree.setRowKey(root, selectedNodeRowKey);
            TreeNode selectedNode = tree.getRowNode();
            ArrayList<String> descendantRowKeys = new ArrayList<String>();
            tree.populateRowKeys(selectedNode, descendantRowKeys);
            int size = descendantRowKeys.size();
            StringBuilder sb = SharedStringBuilder.get(context, SB_DECODE_SELECTION);
            for (int i = 0; i < size; ++i) {
                sb.append((String)descendantRowKeys.get(i));
                if (i == size - 1) continue;
                sb.append(",");
            }
            PrimeFaces.current().ajax().addCallbackParam("descendantRowKeys", sb.toString());
            sb.setLength(0);
            descendantRowKeys = null;
        }
    }

    public void decodeDragDrop(FacesContext context, Tree tree, TreeNode root) {
        TreeNode dropNode;
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(context);
        String dragNodeRowKey = (String)params.get(clientId + "_dragNode");
        String dropNodeRowKey = (String)params.get(clientId + "_dropNode");
        String dragSource = (String)params.get(clientId + "_dragSource");
        int dndIndex = Integer.parseInt((String)params.get(clientId + "_dndIndex"));
        boolean isDroppedNodeCopy = Boolean.parseBoolean((String)params.get(clientId + "_isDroppedNodeCopy"));
        String[] dragNodeRowKeyArr = dragNodeRowKey.split(",");
        ArrayList<TreeNode> dragNodeList = new ArrayList<TreeNode>();
        for (String rowKey : dragNodeRowKeyArr) {
            if (dragSource.equals(clientId)) {
                tree.setRowKey(root, rowKey);
                dragNodeList.add(tree.getRowNode());
                continue;
            }
            Tree otherTree = (Tree)SearchExpressionFacade.resolveComponent(context, (UIComponent)context.getViewRoot(), dragSource);
            otherTree.setRowKey(otherTree.getValue(), rowKey);
            dragNodeList.add(otherTree.getRowNode());
        }
        if (this.isValueBlank(dropNodeRowKey)) {
            dropNode = tree.getValue();
        } else {
            tree.setRowKey(root, dropNodeRowKey);
            dropNode = tree.getRowNode();
        }
        tree.setDropNode(dropNode);
        TreeNode[] dragNodes = new TreeNode[dragNodeList.size()];
        dragNodes = dragNodeList.toArray(dragNodes);
        if (tree.isMultipleDrag()) {
            tree.setDragNodes(dragNodes);
        } else {
            tree.setDragNode(dragNodes[0]);
        }
        if (!tree.isTreeNodeDropped()) {
            return;
        }
        List dropNodeChildren = dropNode.getChildren();
        if (tree.isMultipleDrag()) {
            for (TreeNode dragNode : dragNodes) {
                dropNodeChildren.remove(dragNode);
            }
        }
        for (TreeNode dragNode : dragNodes) {
            if (isDroppedNodeCopy) {
                dragNode = tree.createCopyOfTreeNode(dragNode);
            }
            if (dndIndex >= 0 && dndIndex < dropNode.getChildCount()) {
                dropNodeChildren.add(dndIndex, dragNode);
                continue;
            }
            dropNodeChildren.add(dragNode);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Tree tree = (Tree)component;
        TreeNode root = tree.getValue();
        if (tree.isNodeExpandRequest(context)) {
            boolean vertical = tree.getOrientation().equals("vertical");
            String clientId = tree.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            String rowKey = (String)params.get(clientId + "_expandNode");
            if (!vertical && rowKey.equals("root")) {
                this.encodeHorizontalTreeNodeChildren(context, tree, root, root, tree.getClientId(context), null, tree.isDynamic(), tree.isCheckboxSelectionMode());
            } else {
                tree.setRowKey(root, rowKey);
                TreeNode node = tree.getRowNode();
                node.setExpanded(true);
                if (vertical) {
                    this.encodeTreeNodeChildren(context, tree, root, node, clientId, tree.isDynamic(), tree.isCheckboxSelectionMode(), tree.isDroppable());
                } else {
                    this.encodeHorizontalTreeNodeChildren(context, tree, root, node, tree.getClientId(context), rowKey, tree.isDynamic(), tree.isCheckboxSelectionMode());
                }
                tree.setRowKey(root, null);
            }
        } else if (tree.isFilterRequest(context)) {
            String clientId = tree.getClientId();
            Map params = context.getExternalContext().getRequestParameterMap();
            String filteredValue = (String)params.get(clientId + "_filter");
            Locale filterLocale = LocaleUtils.getCurrentLocale(context);
            tree.getFilteredRowKeys().clear();
            this.encodeFilteredNodes(context, tree, tree.getValue(), filteredValue, filterLocale);
            if (root != null && root.getRowKey() == null) {
                root.setRowKey("root");
                tree.buildRowKeys(root);
                tree.initPreselection();
            }
            if (root != null && (LangUtils.isBlank(filteredValue) || !tree.getFilteredRowKeys().isEmpty())) {
                this.encodeTreeNodeChildren(context, tree, root, root, clientId, tree.isDynamic(), tree.isCheckboxSelectionMode(), tree.isDroppable());
            }
        } else {
            this.encodeMarkup(context, tree);
            this.encodeScript(context, tree);
        }
    }

    protected void encodeFilteredNodes(FacesContext context, Tree tree, TreeNode<?> node, String filteredValue, Locale filterLocale) throws IOException {
        int childCount = node.getChildCount();
        if (childCount > 0) {
            String var = tree.getVar();
            Map requestMap = context.getExternalContext().getRequestMap();
            ValueExpression filterByVE = tree.getValueExpression(TreeBase.PropertyKeys.filterBy.toString());
            FilterConstraint filterConstraint = this.getFilterConstraint(tree);
            for (int i = 0; i < childCount; ++i) {
                TreeNode<?> value;
                TreeNode<?> childNode = node.getChildren().get(i);
                requestMap.put(var, childNode.getData());
                TreeNode<?> treeNode = value = tree.getFilterFunction() == null ? filterByVE.getValue(context.getELContext()) : childNode;
                if (filterConstraint.isMatching(context, value, filteredValue, filterLocale)) {
                    tree.getFilteredRowKeys().add(childNode.getRowKey());
                }
                this.encodeFilteredNodes(context, tree, childNode, filteredValue, filterLocale);
            }
            requestMap.remove(var);
        }
    }

    protected void encodeScript(FacesContext context, Tree tree) throws IOException {
        boolean dynamic = tree.isDynamic();
        String widget = tree.getOrientation().equals("vertical") ? "VerticalTree" : "HorizontalTree";
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init(widget, tree);
        wb.attr("dynamic", dynamic).attr("highlight", tree.isHighlight(), true).attr("animate", tree.isAnimate(), false).attr("droppable", tree.isDroppable(), false).attr("cache", tree.isCache() && dynamic).attr("dragdropScope", tree.getDragdropScope(), null).attr("disabled", tree.isDisabled(), false).callback("onNodeClick", "function(node, event)", tree.getOnNodeClick());
        String selectionMode = tree.getSelectionMode();
        if (selectionMode != null) {
            wb.attr("selectionMode", selectionMode);
            wb.attr("propagateUp", tree.isPropagateSelectionUp());
            wb.attr("propagateDown", tree.isPropagateSelectionDown());
        }
        if (tree.isDraggable()) {
            wb.attr("draggable", true).attr("dragMode", tree.getDragMode()).attr("dropRestrict", tree.getDropRestrict()).attr("multipleDrag", tree.isMultipleDrag()).attr("dropCopyNode", tree.isDropCopyNode());
        }
        if (tree.getOnDrop() != null) {
            wb.attr("controlled", true);
        }
        if (tree.isFiltering()) {
            wb.attr("filter", true).attr("filterMode", tree.getFilterMode(), "lenient");
        }
        this.encodeIconStates(context, tree, wb);
        this.encodeClientBehaviors(context, tree);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Tree tree) throws IOException {
        boolean vertical = tree.getOrientation().equals("vertical");
        TreeNode root = tree.getValue();
        if (root != null && root.getRowKey() == null) {
            root.setRowKey("root");
            tree.buildRowKeys(root);
            tree.initPreselection();
        }
        if (vertical) {
            this.encodeVerticalTree(context, tree, root);
        } else {
            this.encodeHorizontalTree(context, tree, root);
        }
    }

    public void encodeVerticalTree(FacesContext context, Tree tree, TreeNode root) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        boolean dynamic = tree.isDynamic();
        boolean selectionEnabled = tree.isSelectionEnabled();
        boolean multipleSelectionMode = selectionEnabled && tree.isMultipleSelectionMode();
        boolean checkboxSelectionMode = selectionEnabled && tree.isCheckboxSelectionMode();
        boolean droppable = tree.isDroppable();
        boolean isDisabled = tree.isDisabled();
        if (root != null && root.getRowKey() == null) {
            root.setRowKey("root");
            tree.buildRowKeys(root);
            tree.initPreselection();
        }
        if (ComponentUtils.isRTL(context, tree)) {
            tree.setRTLRendering(true);
        }
        String containerClass = tree.isRTLRendering() ? "ui-tree ui-tree-rtl ui-widget ui-widget-content ui-corner-all" : "ui-tree ui-widget ui-widget-content ui-corner-all";
        String string = containerClass = isDisabled ? containerClass + " ui-state-disabled" : containerClass;
        if (tree.getStyleClass() != null) {
            containerClass = containerClass + " " + tree.getStyleClass();
        }
        if (tree.isShowUnselectableCheckbox()) {
            containerClass = containerClass + " ui-tree-checkbox-all";
        }
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tree", null);
        writer.writeAttribute("aria-multiselectable", (Object)String.valueOf(multipleSelectionMode), null);
        if (tree.getStyle() != null) {
            writer.writeAttribute("style", (Object)tree.getStyle(), null);
        }
        if (tree.isFiltering()) {
            this.encodeFilter(context, tree, clientId + "_filter");
        }
        writer.startElement("ul", null);
        if (!isDisabled) {
            writer.writeAttribute("tabindex", (Object)tree.getTabindex(), null);
        }
        writer.writeAttribute("class", (Object)"ui-tree-container", null);
        if (root != null) {
            this.encodeTreeNodeChildren(context, tree, root, root, clientId, dynamic, checkboxSelectionMode, droppable);
        }
        writer.endElement("ul");
        if (selectionEnabled) {
            this.encodeStateHolder(context, tree, clientId + "_selection", tree.getSelectedRowKeysAsString());
        }
        this.encodeStateHolder(context, tree, clientId + "_scrollState", tree.getScrollState());
        writer.endElement("div");
    }

    protected void encodeFilter(FacesContext context, Tree tree, String name) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-tree-filter-container", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("class", (Object)"ui-tree-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all", null);
        writer.writeAttribute("aria-label", (Object)MessageFactory.getMessage("primefaces.input.aria.filter", new Object[0]), null);
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-search", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeHorizontalTree(FacesContext context, Tree tree, TreeNode root) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        boolean dynamic = tree.isDynamic();
        boolean checkboxSelectionMode = tree.isCheckboxSelectionMode();
        String containerClass = tree.getStyleClass() == null ? "ui-tree ui-tree-horizontal ui-widget ui-widget-content ui-corner-all" : "ui-tree ui-tree-horizontal ui-widget ui-widget-content ui-corner-all " + tree.getStyleClass();
        String string = containerClass = tree.isDisabled() ? containerClass + " ui-state-disabled" : containerClass;
        if (tree.isShowUnselectableCheckbox()) {
            containerClass = containerClass + " ui-tree-checkbox-all";
        }
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tree", null);
        if (root != null) {
            this.encodeHorizontalTreeNode(context, tree, root, root, clientId, null, NodeOrder.NONE, dynamic, checkboxSelectionMode);
        }
        if (tree.isSelectionEnabled()) {
            this.encodeStateHolder(context, tree, clientId + "_selection", tree.getSelectedRowKeysAsString());
        }
        writer.endElement("div");
    }

    protected void encodeHorizontalTreeNode(FacesContext context, Tree tree, TreeNode root, TreeNode node, String clientId, String rowKey, NodeOrder nodeOrder, boolean dynamic, boolean checkbox) throws IOException {
        String nodeContentClass;
        String nodeClass;
        ResponseWriter writer = context.getResponseWriter();
        UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
        boolean expanded = node.isExpanded();
        boolean leaf = node.isLeaf();
        boolean selectable = node.isSelectable();
        boolean partialSelected = node.isPartialSelected();
        boolean selected = node.isSelected();
        if (leaf) {
            nodeClass = "ui-treenode ui-treenode-leaf";
        } else {
            nodeClass = "ui-treenode ui-treenode-parent";
            String string = nodeClass = expanded ? nodeClass + " ui-treenode-expanded" : nodeClass + " ui-treenode-collapsed";
        }
        nodeClass = selected ? nodeClass + " ui-treenode-selected" : (partialSelected ? nodeClass + " ui-treenode-hasselected" : nodeClass + " ui-treenode-unselected");
        writer.startElement("table", (UIComponent)tree);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        if (nodeOrder != NodeOrder.NONE) {
            this.encodeConnector(context, tree, nodeOrder);
        }
        writer.startElement("td", null);
        writer.writeAttribute("data-nodetype", (Object)uiTreeNode.getType(), null);
        if (rowKey != null) {
            tree.setRowKey(root, rowKey);
            writer.writeAttribute("data-rowkey", (Object)rowKey, null);
        } else {
            context.getExternalContext().getRequestMap().put(tree.getVar(), tree.getValue().getData());
            writer.writeAttribute("data-rowkey", (Object)"root", null);
        }
        nodeClass = uiTreeNode.getStyleClass() == null ? nodeClass : nodeClass + " " + uiTreeNode.getStyleClass();
        writer.writeAttribute("class", (Object)nodeClass, null);
        String string = nodeContentClass = tree.isSelectionEnabled() && node.isSelectable() ? "ui-treenode-content ui-tree-selectable ui-state-default ui-corner-all" : "ui-treenode-content ui-state-default ui-corner-all";
        if (selected) {
            nodeContentClass = nodeContentClass + " ui-state-highlight";
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)nodeContentClass, null);
        if (!leaf) {
            String toggleIcon = expanded ? "ui-tree-toggler ui-icon ui-icon-minus" : "ui-tree-toggler ui-icon ui-icon-plus";
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)toggleIcon, null);
            writer.endElement("span");
        }
        if (checkbox) {
            RendererUtils.encodeCheckbox(context, selected, partialSelected, !selectable, "ui-selection");
        }
        this.encodeIcon(context, uiTreeNode, expanded);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-treenode-label ui-corner-all", null);
        if (!tree.isDisabled()) {
            writer.writeAttribute("tabindex", (Object)"-1", null);
        }
        writer.writeAttribute("role", (Object)"treeitem", null);
        writer.writeAttribute("aria-label", (Object)uiTreeNode.getAriaLabel(), null);
        uiTreeNode.encodeAll(context);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("td");
        if (!leaf) {
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-treenode-children-container", null);
            if (!expanded) {
                writer.writeAttribute("style", (Object)"display:none", null);
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-treenode-children", null);
            if (dynamic && expanded || !dynamic) {
                this.encodeHorizontalTreeNodeChildren(context, tree, root, node, clientId, rowKey, dynamic, checkbox);
            }
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeHorizontalTreeNodeChildren(FacesContext context, Tree tree, TreeNode root, TreeNode node, String clientId, String rowKey, boolean dynamic, boolean checkbox) throws IOException {
        if (node.getChildCount() == 0) {
            return;
        }
        int childIndex = 0;
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            String childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + "_" + childIndex;
            NodeOrder no = null;
            no = node.getChildCount() == 1 ? NodeOrder.NONE : (childIndex == 0 ? NodeOrder.FIRST : (childIndex == node.getChildCount() - 1 ? NodeOrder.LAST : NodeOrder.MIDDLE));
            this.encodeHorizontalTreeNode(context, tree, root, iterator.next(), clientId, childRowKey, no, dynamic, checkbox);
            ++childIndex;
        }
    }

    protected void encodeConnector(FacesContext context, Tree tree, NodeOrder nodeOrder) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)"ui-treenode-connector", null);
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)"ui-treenode-connector-table", null);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        writer.startElement("td", null);
        if (nodeOrder != NodeOrder.FIRST) {
            writer.writeAttribute("class", (Object)"ui-treenode-connector-line", null);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        if (nodeOrder != NodeOrder.LAST) {
            writer.writeAttribute("class", (Object)"ui-treenode-connector-line", null);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("td");
    }

    public void encodeTreeNode(FacesContext context, Tree tree, TreeNode root, TreeNode node, String clientId, boolean dynamic, boolean checkbox, boolean dragdrop) throws IOException {
        boolean selectable;
        String rowKey = node.getRowKey();
        if (rowKey == null) {
            tree.buildRowKeys(node.getParent());
            rowKey = node.getRowKey();
        }
        boolean selected = node.isSelected();
        boolean partialSelected = node.isPartialSelected();
        boolean isStrictMode = tree.getFilterMode().equals("strict");
        UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
        if (!uiTreeNode.isRendered()) {
            return;
        }
        List<String> filteredRowKeys = tree.getFilteredRowKeys();
        boolean match = false;
        boolean hidden = false;
        if (tree.isFiltering() && !filteredRowKeys.isEmpty()) {
            for (String filteredRowKey : filteredRowKeys) {
                String rowKeyExt = rowKey + "_";
                String filteredRowKeyExt = filteredRowKey + "_";
                boolean isNodeAncestorOfMatch = filteredRowKey.startsWith(rowKeyExt);
                boolean isNodeDescendantOfMatch = rowKey.startsWith(filteredRowKeyExt);
                if (isNodeAncestorOfMatch || !isStrictMode && isNodeDescendantOfMatch || filteredRowKey.equals(rowKey)) {
                    match = true;
                    if (node.isLeaf() || !isNodeAncestorOfMatch) continue;
                    node.setExpanded(true);
                    continue;
                }
                if (!match) continue;
                break;
            }
            if (!match) {
                hidden = true;
            }
        }
        ResponseWriter writer = context.getResponseWriter();
        tree.setRowKey(root, rowKey);
        boolean isLeaf = node.isLeaf();
        boolean expanded = node.isExpanded();
        boolean bl = selectable = tree.isSelectionEnabled() && node.isSelectable();
        String toggleIcon = expanded ? "ui-tree-toggler ui-icon ui-icon-triangle-1-s" : (tree.isRTLRendering() ? "ui-tree-toggler ui-icon ui-icon-triangle-1-w" : "ui-tree-toggler ui-icon ui-icon-triangle-1-e");
        String stateIcon = isLeaf ? "ui-treenode-leaf-icon" : toggleIcon;
        Object datakey = tree.getDatakey();
        String nodeId = clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + rowKey;
        String selectedStateClass = selected ? "ui-treenode-selected" : (partialSelected ? "ui-treenode-hasselected" : "ui-treenode-unselected");
        String containerClass = this.getStyleClassBuilder(context).add(uiTreeNode.getStyleClass()).add(selectedStateClass).add(isLeaf, "ui-treenode ui-treenode-leaf", "ui-treenode ui-treenode-parent").add(hidden, "ui-treenode-hidden").build();
        writer.startElement("li", null);
        writer.writeAttribute("id", (Object)nodeId, null);
        writer.writeAttribute("data-rowkey", (Object)rowKey, null);
        writer.writeAttribute("data-nodetype", (Object)uiTreeNode.getType(), null);
        writer.writeAttribute("class", (Object)containerClass, null);
        if (datakey != null) {
            writer.writeAttribute("data-datakey", datakey, null);
        }
        String contentClass = this.getStyleClassBuilder(context).add(selectable, "ui-treenode-content ui-tree-selectable", "ui-treenode-content").add(dragdrop, "ui-treenode-droppable").add(selected, "ui-state-highlight").build();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)contentClass, null);
        writer.writeAttribute("role", (Object)"treeitem", null);
        if (!tree.isDisabled()) {
            writer.writeAttribute("tabindex", (Object)"-1", null);
        }
        writer.writeAttribute("aria-label", (Object)uiTreeNode.getAriaLabel(), null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(expanded), null);
        writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
        if (checkbox) {
            writer.writeAttribute("aria-checked", (Object)String.valueOf(selected), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)stateIcon, null);
        writer.endElement("span");
        if (checkbox) {
            RendererUtils.encodeCheckbox(context, selected, partialSelected, !selectable, "ui-selection");
        }
        this.encodeIcon(context, uiTreeNode, expanded);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-treenode-label ui-corner-all", null);
        uiTreeNode.encodeAll(context);
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-treenode-children", null);
        writer.writeAttribute("role", (Object)"group", null);
        if (!expanded) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        if (dynamic && expanded || !dynamic) {
            this.encodeTreeNodeChildren(context, tree, root, node, clientId, dynamic, checkbox, dragdrop);
        }
        writer.endElement("ul");
        writer.endElement("li");
        if (dragdrop) {
            this.encodeDropTarget(context, tree);
        }
    }

    public void encodeTreeNodeChildren(FacesContext context, Tree tree, TreeNode<?> root, TreeNode<?> node, String clientId, boolean dynamic, boolean checkbox, boolean droppable) throws IOException {
        int childCount = node.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                if (i == 0 && droppable) {
                    this.encodeDropTarget(context, tree);
                }
                this.encodeTreeNode(context, tree, root, node.getChildren().get(i), clientId, dynamic, checkbox, droppable);
            }
        } else if (droppable && "root".equals(node.getRowKey())) {
            this.encodeDropTarget(context, tree);
        }
    }

    protected void encodeDropTarget(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-tree-droppoint", null);
        writer.endElement("li");
    }

    protected void encodeIconStates(FacesContext context, Tree tree, WidgetBuilder wb) throws IOException {
        Map<String, UITreeNode> nodes = tree.getTreeNodes();
        wb.append(",iconStates:{");
        boolean firstWritten = false;
        for (UITreeNode node : nodes.values()) {
            String expandedIcon = node.getExpandedIcon();
            String collapsedIcon = node.getCollapsedIcon();
            if (expandedIcon == null || collapsedIcon == null) continue;
            if (firstWritten) {
                wb.append(",");
            }
            wb.append("'" + node.getType() + "' : {");
            wb.append("expandedIcon:'" + expandedIcon + "'");
            wb.append(",collapsedIcon:'" + collapsedIcon + "'");
            wb.append("}");
            firstWritten = true;
        }
        wb.append("}");
    }

    protected void encodeIcon(FacesContext context, UITreeNode uiTreeNode, boolean expanded) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        String icon = uiTreeNode.getIconToRender(expanded);
        if (icon != null) {
            writer.writeAttribute("class", (Object)("ui-treenode-icon ui-icon " + icon), null);
        }
        writer.endElement("span");
    }

    protected void encodeStateHolder(FacesContext context, Tree tree, String id, String value) throws IOException {
        this.renderHiddenInput(context, id, value, false);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public FilterConstraint getFilterConstraint(Tree tree) {
        if (tree.getFilterFunction() != null) {
            return new FunctionFilterConstraint(tree.getFilterFunction());
        }
        return FilterConstraints.of(tree.getFilterMatchMode());
    }

    protected static enum NodeOrder {
        FIRST,
        MIDDLE,
        LAST,
        NONE;

    }
}

