/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.TreeTableRenderer;
import org.primefaces.component.treetable.feature.TreeTableFeature;
import org.primefaces.model.TreeNode;
import org.primefaces.util.ComponentUtils;
import org.primefaces.visit.ResetInputVisitCallback;

public class RowEditFeature
implements TreeTableFeature {
    @Override
    public void encode(FacesContext context, TreeTableRenderer renderer, TreeTable tt) throws IOException {
        TreeNode root = tt.getValue();
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tt.getClientId(context);
        String editedRowKey = (String)params.get(clientId + "_rowEditIndex");
        String action = (String)params.get(clientId + "_rowEditAction");
        tt.setRowKey(root, editedRowKey);
        TreeNode node = tt.getRowNode();
        if ("cancel".equals(action)) {
            VisitContext visitContext = null;
            for (UIColumn column : tt.getColumns()) {
                for (UIComponent grandkid : column.getChildren()) {
                    if (!(grandkid instanceof CellEditor)) continue;
                    UIComponent inputFacet = grandkid.getFacet("input");
                    if (inputFacet instanceof EditableValueHolder) {
                        ((EditableValueHolder)inputFacet).resetValue();
                        continue;
                    }
                    if (visitContext == null) {
                        visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
                    }
                    inputFacet.visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
                }
            }
        }
        renderer.encodeNode(context, tt, root, node);
    }

    @Override
    public boolean shouldDecode(FacesContext context, TreeTable table) {
        return false;
    }

    @Override
    public boolean shouldEncode(FacesContext context, TreeTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_rowEditAction");
    }
}

