/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlOutputFormat;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;
import org.primefaces.component.api.FlexAware;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.TouchAware;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UITabPanel;
import org.primefaces.component.api.UITable;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.FastStringWriter;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;

public class ComponentUtils {
    public static final Set<VisitHint> VISIT_HINTS_SKIP_UNRENDERED = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_UNRENDERED));
    public static final Lazy<Set<VisitHint>> VISIT_HINTS_SKIP_ITERATION = new Lazy(() -> Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_ITERATION)));
    public static final String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private static final Object UNDEFINED_VALUE = new Object();

    private ComponentUtils() {
    }

    public static String getValueToRender(FacesContext context, UIComponent component) {
        return ComponentUtils.getValueToRender(context, component, UNDEFINED_VALUE);
    }

    public static String getValueToRender(FacesContext context, UIComponent component, Object value) {
        if (component instanceof ValueHolder) {
            if (component instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)component;
                Object submittedValue = input.getSubmittedValue();
                PrimeConfiguration config = PrimeApplicationContext.getCurrentInstance(context).getConfig();
                if (config.isInterpretEmptyStringAsNull() && submittedValue == null && !input.isLocalValueSet() && context.isValidationFailed() && !input.isValid()) {
                    return null;
                }
                if (submittedValue != null) {
                    return submittedValue.toString();
                }
            }
            ValueHolder valueHolder = (ValueHolder)component;
            if (value == UNDEFINED_VALUE) {
                value = component instanceof HtmlOutputFormat ? ComponentUtils.encodeComponent(component, context) : valueHolder.getValue();
            }
            if (value != null) {
                Converter converter = valueHolder.getConverter();
                if (converter == null) {
                    Class<?> valueType = value.getClass();
                    if (valueType == String.class && !PrimeApplicationContext.getCurrentInstance(context).getConfig().isStringConverterAvailable()) {
                        return (String)value;
                    }
                    converter = context.getApplication().createConverter(valueType);
                }
                if (converter != null) {
                    return converter.getAsString(context, component, value);
                }
                return value.toString();
            }
            return null;
        }
        return null;
    }

    public static Converter getConverter(FacesContext context, UIComponent component) {
        if (!(component instanceof ValueHolder)) {
            return null;
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        Class converterType = valueExpression.getType(context.getELContext());
        return ComponentUtils.getConverter(context, converterType);
    }

    public static Object getConvertedValue(FacesContext context, UIComponent component, Object value) {
        return ComponentUtils.getConvertedValue(context, component, ComponentUtils.getConverter(context, component), value);
    }

    public static Object getConvertedValue(FacesContext context, UIComponent component, Object converter, Object value) {
        Converter converterObject = ComponentUtils.toConverter(context, converter);
        if (converterObject != null) {
            String submittedValue = Objects.toString(value, null);
            if (LangUtils.isBlank(submittedValue)) {
                submittedValue = null;
            }
            return converterObject.getAsObject(context, component, submittedValue);
        }
        return value;
    }

    public static String getConvertedAsString(FacesContext context, UIComponent component, Object value) {
        return ComponentUtils.getConvertedAsString(context, component, null, value);
    }

    public static String getConvertedAsString(FacesContext context, UIComponent component, Object converter, Object value) {
        if (value != null) {
            Converter converterObject = ComponentUtils.toConverter(context, converter);
            if (converterObject == null) {
                converterObject = ComponentUtils.getConverter(context, value.getClass());
            }
            if (converterObject != null) {
                return converterObject.getAsString(context, component, value);
            }
        }
        return Objects.toString(value, null);
    }

    public static Converter getConverter(FacesContext context, Class<?> forClass) {
        if (forClass == null || forClass == Object.class || forClass == String.class && !PrimeApplicationContext.getCurrentInstance(context).getConfig().isStringConverterAvailable()) {
            return null;
        }
        return context.getApplication().createConverter(forClass);
    }

    public static Converter toConverter(FacesContext context, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (object instanceof String) {
            return context.getApplication().createConverter((String)object);
        }
        throw new FacesException("Unsupported type " + object.getClass());
    }

    public static void decodeBehaviors(FacesContext context, UIComponent component) {
        List behaviorsForEvent;
        if (!(component instanceof ClientBehaviorHolder)) {
            return;
        }
        Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (null != behaviorEvent && (behaviorsForEvent = (List)behaviors.get(behaviorEvent)) != null && !behaviorsForEvent.isEmpty()) {
            String behaviorSource = (String)params.get("javax.faces.source");
            String clientId = component.getClientId(context);
            if (behaviorSource != null && clientId.equals(behaviorSource)) {
                for (ClientBehavior behavior : behaviorsForEvent) {
                    behavior.decode(context, component);
                }
            }
        }
    }

    public static String escapeSelector(String selector) {
        return selector.replace(":", "\\\\:");
    }

    public static boolean isRTL(FacesContext context, RTLAware component) {
        return component.isRTL() || PrimeRequestContext.getCurrentInstance(context).isRTL();
    }

    public static boolean isTouchable(FacesContext context, TouchAware component) {
        Boolean local = component.isTouchable();
        if (local != null) {
            return local;
        }
        return PrimeRequestContext.getCurrentInstance(context).isTouchable();
    }

    public static boolean isFlex(FacesContext context, FlexAware component) {
        return component.isFlex() || PrimeRequestContext.getCurrentInstance(context).isFlex();
    }

    public static void processDecodesOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processDecodes(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processDecodes(context);
            }
        }
    }

    public static void processValidatorsOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processValidators(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processValidators(context);
            }
        }
    }

    public static void processUpdatesOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processUpdates(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processUpdates(context);
            }
        }
    }

    public static NavigationCase findNavigationCase(FacesContext context, String outcome) {
        ConfigurableNavigationHandler navHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
        String outcomeValue = outcome == null ? context.getViewRoot().getViewId() : outcome;
        return navHandler.getNavigationCase(context, null, outcomeValue);
    }

    public static Map<String, List<String>> getUIParams(UIComponent component) {
        LinkedHashMap<String, ArrayList<String>> params = null;
        for (int i = 0; i < component.getChildCount(); ++i) {
            ArrayList<String> paramValues;
            UIParameter uiParam;
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (!child.isRendered() || !(child instanceof UIParameter) || (uiParam = (UIParameter)child).isDisable()) continue;
            if (params == null) {
                params = new LinkedHashMap<String, ArrayList<String>>(5);
            }
            if ((paramValues = (ArrayList<String>)params.get(uiParam.getName())) == null) {
                paramValues = new ArrayList<String>(2);
                params.put(uiParam.getName(), paramValues);
            }
            paramValues.add(String.valueOf(uiParam.getValue()));
        }
        return params;
    }

    public static boolean isSkipIteration(VisitContext visitContext, FacesContext context) {
        if (PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isAtLeastJsf21()) {
            return visitContext.getHints().contains(VisitHint.SKIP_ITERATION);
        }
        Boolean skipIterationHint = (Boolean)visitContext.getFacesContext().getAttributes().get(SKIP_ITERATION_HINT);
        return skipIterationHint != null && skipIterationHint != false;
    }

    public static <T extends Renderer> T getUnwrappedRenderer(FacesContext context, String family, String rendererType) {
        Renderer renderer = context.getRenderKit().getRenderer(family, rendererType);
        while (renderer instanceof FacesWrapper) {
            renderer = (Renderer)((FacesWrapper)renderer).getWrapped();
        }
        return (T)renderer;
    }

    public static String calculateViewId(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String viewId = (String)requestMap.get("javax.servlet.include.path_info");
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestServletPath();
        }
        return viewId;
    }

    public static String encodeURI(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string, "UTF-8").replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
    }

    public static String createContentDisposition(String value, String filename) {
        try {
            return String.format("%s;filename=\"%2$s\"; filename*=UTF-8''%2$s", value, ComponentUtils.encodeURI(filename));
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static boolean isRequestSource(UIComponent component, FacesContext context) {
        String partialSource = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        return component.getClientId(context).equals(partialSource);
    }

    public static boolean isRequestSource(UIComponent component, FacesContext context, String event) {
        ExternalContext externalContext = context.getExternalContext();
        String partialSource = (String)externalContext.getRequestParameterMap().get("javax.faces.source");
        String partialEvent = (String)externalContext.getRequestParameterMap().get("javax.faces.behavior.event");
        return component.getClientId(context).equals(partialSource) && partialEvent.equals(event);
    }

    public static Object getLabel(FacesContext facesContext, UIComponent component) {
        String label = (String)component.getAttributes().get("label");
        if (label == null) {
            label = component.getClientId(facesContext);
        }
        return label;
    }

    public static boolean shouldRenderFacet(UIComponent facet, boolean alwaysRender) {
        if (facet == null) {
            return false;
        }
        if (alwaysRender) {
            return true;
        }
        if (facet.getClass().equals(UIPanel.class)) {
            if (!facet.isRendered()) {
                return false;
            }
            return ComponentUtils.shouldRenderChildren(facet);
        }
        return facet.isRendered();
    }

    public static boolean shouldRenderFacet(UIComponent facet) {
        return ComponentUtils.shouldRenderFacet(facet, false);
    }

    public static boolean shouldRenderChildren(UIComponent component) {
        for (int i = 0; i < component.getChildCount(); ++i) {
            if (!((UIComponent)component.getChildren().get(i)).isRendered()) continue;
            return true;
        }
        return false;
    }

    public static <T> T eval(StateHelper stateHelper, Serializable key, Supplier<T> defaultValueSupplier) {
        Object value = stateHelper.eval(key, null);
        if (value == null) {
            value = defaultValueSupplier.get();
        }
        return (T)value;
    }

    public static <T> T computeIfAbsent(StateHelper stateHelper, Serializable key, Supplier<T> defaultValueSupplier) {
        Object value = stateHelper.get(key);
        if (value == null) {
            value = defaultValueSupplier.get();
            stateHelper.put(key, value);
        }
        return (T)value;
    }

    public static ViewPoolingResetMode isViewPooling(FacesContext context) {
        if (context.getViewRoot() != null) {
            Object mode = context.getViewRoot().getAttributes().get("oam.view.resetSaveStateMode");
            if (Objects.equals(mode, 1)) {
                return ViewPoolingResetMode.SOFT;
            }
            if (Objects.equals(mode, 2)) {
                return ViewPoolingResetMode.HARD;
            }
        }
        return ViewPoolingResetMode.OFF;
    }

    public static boolean isNestedWithinIterator(UIComponent component) {
        UIComponent parent = component;
        while (null != (parent = parent.getParent())) {
            if (!(parent instanceof UIData) && !parent.getClass().getName().endsWith("UIRepeat") && (!(parent instanceof UITabPanel) || !((UITabPanel)parent).isRepeating())) continue;
            return true;
        }
        return false;
    }

    public static void encodeIndexedId(FacesContext context, UIComponent component, int index) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        FastStringWriter fsw = new FastStringWriter();
        context.setResponseWriter(writer.cloneWithWriter((Writer)fsw));
        component.encodeAll(context);
        context.setResponseWriter(writer);
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        String encodedComponent = fsw.toString();
        encodedComponent = encodedComponent.replaceAll("\\sid=\"(.*?)\"", " id=\"$1" + separator + index + "\"");
        writer.write(encodedComponent);
    }

    public static Object getDynamicColumnValue(UIComponent component) {
        UIColumn column = ComponentTraversalUtils.closest(UIColumn.class, component);
        UITable table = ComponentTraversalUtils.closest(UITable.class, (UIComponent)column);
        return table.getFieldValue(FacesContext.getCurrentInstance(), column);
    }

    public static String getDynamicColumnValueAsString(UIComponent component) {
        UIColumn column = ComponentTraversalUtils.closest(UIColumn.class, component);
        UITable table = ComponentTraversalUtils.closest(UITable.class, (UIComponent)column);
        return table.getConvertedFieldValue(FacesContext.getCurrentInstance(), column);
    }

    public static String encodeComponent(UIComponent component, FacesContext context) {
        FastStringWriter output = new FastStringWriter();
        ResponseWriter originalWriter = context.getResponseWriter();
        if (originalWriter != null) {
            context.setResponseWriter(originalWriter.cloneWithWriter((Writer)output));
        } else {
            context.setResponseWriter(RendererUtils.getRenderKit(context).createResponseWriter((Writer)output, "text/html", "UTF-8"));
        }
        try {
            component.encodeAll(context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (originalWriter != null) {
                context.setResponseWriter(originalWriter);
            }
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeInRequestScope(FacesContext context, String var, Object value, Supplier<T> callback) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object oldValue = requestMap.remove(var);
        try {
            requestMap.put(var, value);
            T t = callback.get();
            return t;
        }
        finally {
            requestMap.remove(var);
            if (oldValue != null) {
                requestMap.put(var, oldValue);
            }
        }
    }

    public static int getRenderedChildCount(UIComponent component) {
        int renderedChildCount = 0;
        for (int i = 0; i < component.getChildCount(); ++i) {
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (!child.isRendered()) continue;
            ++renderedChildCount;
        }
        return renderedChildCount;
    }

    public static boolean isDisabledOrReadonly(UIInput component) {
        return Boolean.parseBoolean(String.valueOf(component.getAttributes().get("disabled"))) || Boolean.parseBoolean(String.valueOf(component.getAttributes().get("readonly")));
    }

    public static enum ViewPoolingResetMode {
        OFF,
        SOFT,
        HARD;

    }
}

