/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inplace;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inplace.Inplace;
import org.primefaces.component.password.Password;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class InplaceRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Inplace inplace = (Inplace)component;
        this.encodeMarkup(context, inplace);
        this.encodeScript(context, inplace);
    }

    protected void encodeMarkup(FacesContext context, Inplace inplace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inplace.getClientId(context);
        String widgetVar = inplace.resolveWidgetVar(context);
        String userStyle = inplace.getStyle();
        boolean disabled = inplace.isDisabled();
        boolean validationFailed = context.isValidationFailed() && !inplace.isValid();
        UIComponent outputFacet = inplace.getFacet("output");
        boolean shouldRenderFacet = ComponentUtils.shouldRenderFacet(outputFacet);
        boolean withPassword = !shouldRenderFacet && this.isPassword((UIComponent)inplace.getChildren().get(0));
        String styleClass = this.getStyleClassBuilder(context).add("ui-inplace ui-hidden-container", inplace.getStyleClass()).add(withPassword, "p-password").build();
        String mode = inplace.getMode();
        writer.startElement("span", (UIComponent)inplace);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        if (userStyle != null) {
            writer.writeAttribute("style", (Object)userStyle, "id");
        }
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        String outputStyleClass = disabled ? "ui-inplace-display-disabled" : "ui-inplace-display";
        String outputStyle = this.getStyleBuilder(context).add(validationFailed, "display", "none").add(!validationFailed && "output".equals(mode), "display", "inline").add(!validationFailed && "input".equals(mode), "display", "none").build();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_display"), "id");
        writer.writeAttribute("class", (Object)outputStyleClass, null);
        writer.writeAttribute("style", (Object)outputStyle, null);
        if (inplace.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)inplace.getTabindex(), null);
            writer.writeAttribute("role", (Object)"button", null);
        }
        if (shouldRenderFacet) {
            outputFacet.encodeAll(context);
        } else {
            this.encodeLabel(context, inplace, withPassword);
        }
        writer.endElement("span");
        String inputStyle = this.getStyleBuilder(context).add(validationFailed, "display", "inline").add(!validationFailed && "output".equals(mode), "display", "none").add(!validationFailed && "input".equals(mode), "display", "inline").build();
        UIComponent inputFacet = inplace.getFacet("input");
        if (!inplace.isDisabled()) {
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(clientId + "_content"), "id");
            writer.writeAttribute("class", (Object)"ui-inplace-content", null);
            writer.writeAttribute("style", (Object)inputStyle, null);
            if (ComponentUtils.shouldRenderFacet(inputFacet)) {
                inputFacet.encodeAll(context);
            } else {
                this.renderChildren(context, (UIComponent)inplace);
            }
            if (inplace.isEditor()) {
                this.encodeEditor(context, inplace);
            }
            writer.endElement("span");
        }
        writer.endElement("span");
    }

    protected void encodeLabel(FacesContext context, Inplace inplace, boolean withPassword) throws IOException {
        boolean needsWrapping;
        ResponseWriter writer = context.getResponseWriter();
        UIComponent editor = (UIComponent)inplace.getChildren().get(0);
        String value = ComponentUtils.getValueToRender(context, editor);
        boolean bl = needsWrapping = withPassword && LangUtils.isBlank(inplace.getLabel()) && !LangUtils.isBlank(value);
        if (needsWrapping) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"p-masked", null);
            writer.writeText((Object)"", null);
        } else {
            writer.writeText((Object)this.getLabelToRender(context, inplace, value), null);
        }
        if (needsWrapping) {
            writer.endElement("span");
        }
    }

    protected boolean isPassword(UIComponent editor) {
        return editor instanceof Password || "password".equalsIgnoreCase(String.valueOf(editor.getAttributes().get("type")));
    }

    protected String getLabelToRender(FacesContext context, Inplace inplace, String value) {
        String label = inplace.getLabel();
        if (!this.isValueBlank(label)) {
            return label;
        }
        if (LangUtils.isBlank(value)) {
            String emptyLabel = inplace.getEmptyLabel();
            if (emptyLabel != null) {
                return emptyLabel;
            }
            return "";
        }
        return value;
    }

    protected void encodeScript(FacesContext context, Inplace inplace) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Inplace", inplace).attr("effect", inplace.getEffect()).attr("effectSpeed", inplace.getEffectSpeed()).attr("event", inplace.getEvent()).attr("toggleable", inplace.isToggleable(), false).attr("disabled", inplace.isDisabled(), false).attr("editor", inplace.isEditor(), false);
        this.encodeClientBehaviors(context, inplace);
        wb.finish();
    }

    protected void encodeEditor(FacesContext context, Inplace inplace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(inplace.getClientId(context) + "_editor"), null);
        writer.writeAttribute("class", (Object)"ui-inplace-editor", null);
        this.encodeButton(context, inplace.getSaveLabel(), "ui-inplace-save", "ui-icon-check");
        this.encodeButton(context, inplace.getCancelLabel(), "ui-inplace-cancel", "ui-icon-close");
        writer.endElement("span");
    }

    protected void encodeButton(FacesContext context, String title, String styleClass, String icon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)("ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only " + styleClass), null);
        writer.writeAttribute("title", (Object)title, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.write("ui-button");
        writer.endElement("span");
        writer.endElement("button");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

