/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.OverlayMenu;
import org.primefaces.component.menubutton.MenuButton;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.MenuModel;
import org.primefaces.renderkit.MenuItemAwareRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public abstract class BaseMenuRenderer
extends MenuItemAwareRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AbstractMenu menu = (AbstractMenu)component;
        MenuModel model = menu.getModel();
        if (model != null && menu.getElementsCount() > 0) {
            model.generateUniqueIds();
        }
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected abstract void encodeMarkup(FacesContext var1, AbstractMenu var2) throws IOException;

    protected abstract void encodeScript(FacesContext var1, AbstractMenu var2) throws IOException;

    protected String getLinkStyleClass(MenuItem menuItem) {
        String styleClass = menuItem.getStyleClass();
        return styleClass == null ? "ui-menuitem-link ui-corner-all" : "ui-menuitem-link ui-corner-all " + styleClass;
    }

    protected void encodeMenuItem(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        this.encodeMenuItem(context, menu, menuitem, "-1");
    }

    protected void encodeMenuItem(FacesContext context, AbstractMenu menu, MenuItem menuitem, String tabindex) throws IOException {
        this.encodeMenuItem(context, menu, menuitem, tabindex, new AbstractMap.SimpleEntry<String, String>("role", "menuitem"));
    }

    protected void encodeMenuItem(FacesContext context, AbstractMenu menu, MenuItem menuitem, String tabindex, Map.Entry<String, String> aria) throws IOException {
        UIComponent uiMenuItem;
        UIComponent custom;
        boolean isMenuItemComponent = menuitem instanceof UIComponent;
        if (isMenuItemComponent && ComponentUtils.shouldRenderFacet(custom = (uiMenuItem = (UIComponent)menuitem).getFacet("custom"))) {
            custom.encodeAll(context);
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String title = menuitem.getTitle();
        String style = menuitem.getStyle();
        boolean disabled = menuitem.isDisabled();
        String rel = menuitem.getRel();
        String ariaLabel = menuitem.getAriaLabel();
        writer.startElement("a", null);
        writer.writeAttribute("tabindex", (Object)tabindex, null);
        if (aria != null) {
            writer.writeAttribute(aria.getKey(), (Object)aria.getValue(), null);
        }
        if (this.shouldRenderId(menuitem)) {
            writer.writeAttribute("id", (Object)menuitem.getClientId(), null);
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        String styleClass = this.getLinkStyleClass(menuitem);
        if (disabled) {
            styleClass = styleClass + " ui-state-disabled";
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (rel != null) {
            writer.writeAttribute("rel", (Object)rel, null);
        }
        if (LangUtils.isNotEmpty(ariaLabel)) {
            writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        }
        if (disabled) {
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)"return false;", null);
        } else {
            this.encodeOnClick(context, (UIComponent)menu, menuitem);
        }
        if (isMenuItemComponent) {
            this.renderPassThruAttributes(context, (UIComponent)menuitem, new List[0]);
        }
        this.encodeMenuItemContent(context, menu, menuitem);
        writer.endElement("a");
    }

    protected boolean shouldRenderId(MenuElement element) {
        if (element instanceof UIComponent) {
            UIComponent component = (UIComponent)element;
            return component.getParent() instanceof MenuButton || this.shouldWriteId(component);
        }
        return false;
    }

    protected void encodeMenuItemContent(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        boolean isIconLeft;
        ResponseWriter writer = context.getResponseWriter();
        Object value = menuitem.getValue();
        String iconPos = menuitem.getIconPos();
        boolean bl = isIconLeft = "left".equals(iconPos) || LangUtils.isBlank(iconPos);
        if (isIconLeft) {
            this.encodeIcon(writer, menu, menuitem, isIconLeft);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
        if (menuitem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuitem);
        } else if (value != null) {
            if (menuitem.isEscape()) {
                writer.writeText(value, "value");
            } else {
                writer.write(value.toString());
            }
        }
        writer.endElement("span");
        boolean isIconRight = "right".equals(menuitem.getIconPos());
        if (isIconRight) {
            this.encodeIcon(writer, menu, menuitem, isIconRight);
        }
    }

    protected void encodeIcon(ResponseWriter writer, AbstractMenu menu, MenuItem menuitem, boolean shouldRender) throws IOException {
        String icon = menuitem.getIcon();
        if (icon != null && shouldRender) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon + " ui-menuitem-icon-" + menuitem.getIconPos()), null);
            writer.writeAttribute("aria-hidden", (Object)"true", null);
            writer.endElement("span");
        }
    }

    protected void encodeOverlayConfig(FacesContext context, OverlayMenu menu, WidgetBuilder wb) throws IOException {
        wb.attr("overlay", true).attr("my", menu.getMy()).attr("at", menu.getAt());
        String trigger = menu.getTrigger();
        if (trigger != null) {
            wb.attr("trigger", SearchExpressionFacade.resolveClientIds(context, (UIComponent)menu, trigger)).attr("triggerEvent", menu.getTriggerEvent());
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeKeyboardTarget(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("tabindex", (Object)menu.getTabindex(), null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.endElement("div");
    }
}

