/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.slider;

import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.slider.SliderBase;
import org.primefaces.event.SlideEndEvent;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MapBuilder;
import org.primefaces.util.MessageFactory;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Slider
extends SliderBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Slider";
    public static final String VALUE_OUT_OF_RANGE = "primefaces.slider.OUT_OF_RANGE";
    private static final String DEFAULT_EVENT = "slideEnd";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("slideEnd", SlideEndEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (DEFAULT_EVENT.equals(eventName)) {
                double sliderValue = Double.parseDouble((String)params.get(clientId + "_slideValue"));
                SlideEndEvent slideEndEvent = new SlideEndEvent((UIComponent)this, behaviorEvent.getBehavior(), sliderValue);
                slideEndEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)slideEndEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void validate(FacesContext context) {
        super.validate(context);
        if (!this.isValid()) {
            return;
        }
        if ("true".equals(this.getRange())) {
            String[] inputIds = this.getFor().split(",");
            UIInput inputFrom = (UIInput)SearchExpressionFacade.resolveComponent(context, (UIComponent)this, inputIds[0]);
            UIInput inputTo = (UIInput)SearchExpressionFacade.resolveComponent(context, (UIComponent)this, inputIds[1]);
            String valueFromStr = this.getValueAsStringOfAttachedInput(context, inputFrom);
            String valueToStr = this.getValueAsStringOfAttachedInput(context, inputTo);
            if (LangUtils.isBlank(valueFromStr) || LangUtils.isBlank(valueToStr)) {
                return;
            }
            double valueFrom = Double.parseDouble(valueFromStr);
            double valueTo = Double.parseDouble(valueToStr);
            if (valueTo < valueFrom) {
                this.setValid(false);
                inputFrom.setValid(false);
                inputTo.setValid(false);
            } else {
                if (valueFrom < this.getMinValue() || valueFrom > this.getMaxValue()) {
                    this.setValid(false);
                    inputFrom.setValid(false);
                }
                if (valueTo > this.getMaxValue() || valueTo < this.getMinValue()) {
                    this.setValid(false);
                    inputTo.setValid(false);
                }
            }
        } else {
            UIInput input = (UIInput)SearchExpressionFacade.resolveComponent(context, (UIComponent)this, this.getFor());
            String value = this.getValueAsStringOfAttachedInput(context, input);
            if (LangUtils.isBlank(value)) {
                return;
            }
            double submittedValueDouble = Double.parseDouble(value);
            if (submittedValueDouble < this.getMinValue() || submittedValueDouble > this.getMaxValue()) {
                this.setValid(false);
                input.setValid(false);
            }
        }
        if (!this.isValid()) {
            String validatorMessage = this.getValidatorMessage();
            FacesMessage msg = null;
            if (validatorMessage != null) {
                msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage);
            } else {
                Object params = ComponentUtils.getLabel(context, (UIComponent)this);
                msg = MessageFactory.getFacesMessage(VALUE_OUT_OF_RANGE, FacesMessage.SEVERITY_ERROR, params);
            }
            context.addMessage(this.getClientId(context), msg);
        }
    }

    protected String getValueAsStringOfAttachedInput(FacesContext context, UIInput input) {
        Object value;
        Object submittedValue = input.getSubmittedValue();
        if (submittedValue != null) {
            if (submittedValue instanceof String) {
                return (String)submittedValue;
            }
            Converter converter = ComponentUtils.getConverter(context, (UIComponent)input);
            if (converter != null) {
                return converter.getAsString(context, (UIComponent)this, submittedValue);
            }
            throw new FacesException("No converter available for: " + submittedValue.getClass());
        }
        if (input.isLocalValueSet() && (value = input.getValue()) != null) {
            if (value instanceof String) {
                return (String)value;
            }
            Converter converter = ComponentUtils.getConverter(context, (UIComponent)input);
            if (converter != null) {
                return converter.getAsString(context, (UIComponent)this, value);
            }
            throw new FacesException("No converter available for: " + value.getClass());
        }
        return null;
    }
}

