/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostRestoreStateEvent;
import org.primefaces.PrimeFaces;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.treetable.TreeTableBase;
import org.primefaces.component.treetable.TreeTableState;
import org.primefaces.component.treetable.feature.FilterFeature;
import org.primefaces.component.treetable.feature.TreeTableFeatures;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.CellEditEvent;
import org.primefaces.event.ColumnResizeEvent;
import org.primefaces.event.NodeCollapseEvent;
import org.primefaces.event.NodeExpandEvent;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.event.NodeUnselectEvent;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.data.FilterEvent;
import org.primefaces.event.data.PageEvent;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.ColumnMeta;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.SortMeta;
import org.primefaces.model.TreeNode;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="touch/touchswipe.js")})
public class TreeTable
extends TreeTableBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.TreeTable";
    public static final String CONTAINER_CLASS = "ui-treetable ui-widget";
    public static final String RESIZABLE_CONTAINER_CLASS = "ui-treetable ui-treetable-resizable ui-widget";
    public static final String HEADER_CLASS = "ui-treetable-header ui-widget-header ui-corner-top";
    public static final String DATA_CLASS = "ui-treetable-data ui-widget-content";
    public static final String FOOTER_CLASS = "ui-treetable-footer ui-widget-header ui-corner-bottom";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String SORTABLE_COLUMN_HEADER_CLASS = "ui-state-default ui-sortable-column";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String SELECTED_ROW_CLASS = "ui-widget-content ui-state-highlight ui-selected";
    public static final String COLUMN_CONTENT_WRAPPER = "ui-tt-c";
    public static final String EXPAND_ICON = "ui-treetable-toggler ui-icon ui-icon-triangle-1-e ui-c";
    public static final String COLLAPSE_ICON = "ui-treetable-toggler ui-icon ui-icon-triangle-1-s ui-c";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-treetable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-widget-header ui-treetable-scrollable-header";
    public static final String SCROLLABLE_HEADER_BOX_CLASS = "ui-treetable-scrollable-header-box";
    public static final String SCROLLABLE_BODY_CLASS = "ui-treetable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-widget-header ui-treetable-scrollable-footer";
    public static final String SCROLLABLE_FOOTER_BOX_CLASS = "ui-treetable-scrollable-footer-box";
    public static final String SELECTABLE_NODE_CLASS = "ui-treetable-selectable-node";
    public static final String RESIZABLE_COLUMN_CLASS = "ui-resizable-column";
    public static final String INDENT_CLASS = "ui-treetable-indent";
    public static final String EMPTY_MESSAGE_ROW_CLASS = "ui-widget-content ui-treetable-empty-message";
    public static final String PARTIAL_SELECTED_CLASS = "ui-treetable-partialselected";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String SORTABLE_COLUMN_ASCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
    public static final String SORTABLE_COLUMN_DESCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
    public static final String SORTABLE_PRIORITY_CLASS = "ui-sortable-column-badge ui-helper-hidden";
    public static final String REFLOW_CLASS = "ui-treetable-reflow";
    public static final String FILTER_COLUMN_CLASS = "ui-filter-column";
    public static final String COLUMN_INPUT_FILTER_CLASS = "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
    public static final String COLUMN_CUSTOM_FILTER_CLASS = "ui-column-customfilter";
    public static final String HIDDEN_COLUMN_CLASS = "ui-helper-hidden";
    public static final String STATIC_COLUMN_CLASS = "ui-static-column";
    public static final String EDITABLE_COLUMN_CLASS = "ui-editable-column";
    public static final String EDITING_ROW_CLASS = "ui-row-editing";
    public static final String GRIDLINES_CLASS = "ui-treetable-gridlines";
    public static final String SMALL_SIZE_CLASS = "ui-treetable-sm";
    public static final String LARGE_SIZE_CLASS = "ui-treetable-lg";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("contextMenu", NodeSelectEvent.class).put("select", NodeSelectEvent.class).put("unselect", NodeUnselectEvent.class).put("expand", NodeExpandEvent.class).put("collapse", NodeCollapseEvent.class).put("colResize", ColumnResizeEvent.class).put("sort", SortEvent.class).put("filter", FilterEvent.class).put("rowEdit", RowEditEvent.class).put("rowEditInit", RowEditEvent.class).put("rowEditCancel", RowEditEvent.class).put("cellEdit", CellEditEvent.class).put("cellEditInit", CellEditEvent.class).put("cellEditCancel", CellEditEvent.class).put("page", PageEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private List<UIColumn> columns;
    private List<String> filteredRowKeys = new ArrayList<String>();
    private Map<String, AjaxBehaviorEvent> deferredEvents = new HashMap<String, AjaxBehaviorEvent>(1);

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            TreeNode root = this.getValue();
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("expand".equals(eventName)) {
                String nodeKey = (String)params.get(clientId + "_expand");
                this.setRowKey(root, nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeExpandEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if ("collapse".equals(eventName)) {
                String nodeKey = (String)params.get(clientId + "_collapse");
                this.setRowKey(root, nodeKey);
                TreeNode node = this.getRowNode();
                node.setExpanded(false);
                wrapperEvent = new NodeCollapseEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if ("select".equals(eventName)) {
                String nodeKey = (String)params.get(clientId + "_instantSelection");
                this.setRowKey(root, nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if ("contextMenu".equals(eventName)) {
                String nodeKey = (String)params.get(clientId + "_instantSelection");
                this.setRowKey(root, nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), node, true);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if ("unselect".equals(eventName)) {
                String nodeKey = (String)params.get(clientId + "_instantUnselection");
                this.setRowKey(root, nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeUnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if ("colResize".equals(eventName)) {
                String columnId = (String)params.get(clientId + "_columnId");
                int width = Integer.parseInt((String)params.get(clientId + "_width"));
                int height = Integer.parseInt((String)params.get(clientId + "_height"));
                wrapperEvent = new ColumnResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), width, height, this.findColumn(columnId));
            } else if ("sort".equals(eventName)) {
                wrapperEvent = new SortEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getSortByAsMap());
            } else {
                if ("filter".equals(eventName)) {
                    this.deferredEvents.put("filter", (AjaxBehaviorEvent)event);
                    return;
                }
                if ("rowEdit".equals(eventName) || "rowEditCancel".equals(eventName) || "rowEditInit".equals(eventName)) {
                    String nodeKey = (String)params.get(clientId + "_rowEditIndex");
                    this.setRowKey(root, nodeKey);
                    wrapperEvent = new RowEditEvent<TreeNode>((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
                    wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
                } else if ("cellEdit".equals(eventName) || "cellEditCancel".equals(eventName) || "cellEditInit".equals(eventName)) {
                    String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
                    String rowKey = cellInfo[0];
                    int cellIndex = Integer.parseInt(cellInfo[1]);
                    int i = -1;
                    UIColumn column = null;
                    for (UIColumn col : this.getColumns()) {
                        if (!col.isRendered() || ++i != cellIndex) continue;
                        column = col;
                        break;
                    }
                    wrapperEvent = new CellEditEvent((UIComponent)this, behaviorEvent.getBehavior(), column, rowKey);
                    wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
                } else if ("page".equals(eventName)) {
                    int rows = this.getRowsToRender();
                    int first = Integer.parseInt((String)params.get(clientId + "_first"));
                    int page = rows > 0 ? first / rows : 0;
                    wrapperEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page);
                    wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
                }
            }
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        TreeNode<?> filteredValue;
        super.processEvent(event);
        if (event instanceof PostRestoreStateEvent && this.isFilteringEnabled() && this == event.getComponent() && (filteredValue = this.getFilteredValue()) != null) {
            this.setValue(filteredValue);
        }
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (this.isToggleRequest(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        super.processValidators(context);
        FilterFeature feature = TreeTableFeatures.filterFeature();
        if (feature.shouldDecode(context, this)) {
            feature.decode(context, this);
            AjaxBehaviorEvent event = this.deferredEvents.get("filter");
            if (event != null) {
                FilterEvent wrappedEvent = new FilterEvent((UIComponent)this, event.getBehavior(), this.getFilterByAsMap());
                wrappedEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                super.queueEvent((FacesEvent)wrappedEvent);
            }
        }
    }

    @Override
    public boolean hasFooterColumn() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Column column;
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!(child instanceof Column) || !child.isRendered() || (column = (Column)child).getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    private boolean isToggleRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_expand") != null || params.get(clientId + "_collapse") != null;
    }

    public boolean isResizeRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_colResize") != null;
    }

    public String getScrollState() {
        String name;
        Map params = this.getFacesContext().getExternalContext().getRequestParameterMap();
        String value = (String)params.get(name = this.getClientId() + "_scrollState");
        return value == null ? "0,0" : value;
    }

    public Locale resolveDataLocale() {
        FacesContext context = this.getFacesContext();
        return LocaleUtils.resolveLocale(context, this.getDataLocale(), this.getClientId(context));
    }

    @Override
    public List<UIColumn> getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        List columns = this.collectColumns();
        if (this.getFacesContext().getCurrentPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.columns = columns;
        }
        return columns;
    }

    @Override
    public void setColumns(List<UIColumn> columns) {
        this.columns = columns;
    }

    public Object saveState(FacesContext context) {
        this.resetDynamicColumns();
        if (this.isFilteringEnabled()) {
            this.setValue(null);
        }
        this.columns = null;
        this.filteredRowKeys = new ArrayList<String>();
        return super.saveState(context);
    }

    @Override
    public int getRowCount() {
        TreeNode root = this.getValue();
        if (root == null) {
            return -1;
        }
        List children = root.getChildren();
        return children == null ? -1 : children.size();
    }

    @Override
    public int getPage() {
        if (this.getRowCount() > 0) {
            int rows = this.getRowsToRender();
            if (rows > 0) {
                int first = this.getFirst();
                return first / rows;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int getRowsToRender() {
        int rows = this.getRows();
        return rows == 0 ? this.getRowCount() : rows;
    }

    @Override
    public int getPageCount() {
        return (int)Math.ceil((double)this.getRowCount() * 1.0 / (double)this.getRowsToRender());
    }

    public UIComponent getHeader() {
        return this.getFacet("header");
    }

    public UIComponent getFooter() {
        return this.getFacet("footer");
    }

    public void calculateFirst() {
        int rows = this.getRows();
        if (rows > 0) {
            int first = this.getFirst();
            int rowCount = this.getRowCount();
            if (rowCount > 0 && first >= rowCount) {
                int numberOfPages = (int)Math.ceil((double)rowCount * 1.0 / (double)rows);
                this.setFirst(Math.max((numberOfPages - 1) * rows, 0));
            }
        }
    }

    public void updatePaginationData(FacesContext context) {
        String componentClientId = this.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        ELContext elContext = context.getELContext();
        String firstParam = (String)params.get(componentClientId + "_first");
        String rowsParam = (String)params.get(componentClientId + "_rows");
        int newRowsValue = "*".equals(rowsParam) ? this.getRowCount() : Integer.parseInt(rowsParam);
        this.setFirst(Integer.parseInt(firstParam));
        this.setRows(newRowsValue);
        ValueExpression firstVe = this.getValueExpression("first");
        ValueExpression rowsVe = this.getValueExpression("rows");
        if (firstVe != null && !firstVe.isReadOnly(elContext)) {
            firstVe.setValue(context.getELContext(), (Object)this.getFirst());
        }
        if (rowsVe != null && !rowsVe.isReadOnly(elContext)) {
            rowsVe.setValue(context.getELContext(), (Object)this.getRows());
        }
    }

    public void updateFilteredValue(FacesContext context, TreeNode node) {
        ValueExpression ve = this.getValueExpression(TreeTableBase.PropertyKeys.filteredValue.name());
        if (ve != null) {
            ve.setValue(context.getELContext(), (Object)node);
        } else {
            this.setFilteredValue(node);
        }
    }

    public List<String> getFilteredRowKeys() {
        return this.filteredRowKeys;
    }

    public void setFilteredRowKeys(List<String> filteredRowKeys) {
        this.filteredRowKeys = filteredRowKeys;
    }

    @Override
    protected void preDecode(FacesContext context) {
        this.resetDynamicColumns();
        super.preDecode(context);
    }

    @Override
    protected void preValidate(FacesContext context) {
        this.resetDynamicColumns();
        super.preValidate(context);
    }

    @Override
    protected void preUpdate(FacesContext context) {
        this.resetDynamicColumns();
        super.preUpdate(context);
    }

    @Override
    protected void preEncode(FacesContext context) {
        this.resetDynamicColumns();
        super.preEncode(context);
    }

    @Override
    protected boolean requiresColumns() {
        return true;
    }

    @Override
    public void restoreMultiViewState() {
        TreeTableState ts = this.getMultiViewState(false);
        if (ts != null) {
            if (this.isPaginator()) {
                this.setFirst(ts.getFirst());
                int rows = ts.getRows() == 0 ? this.getRows() : ts.getRows();
                this.setRows(rows);
            }
            if (ts.getSortBy() != null) {
                this.updateSortByWithMVS(ts.getSortBy());
            }
            if (ts.getFilterBy() != null) {
                this.updateFilterByWithMVS(this.getFacesContext(), ts.getFilterBy());
            }
            this.setColumnMeta(ts.getColumnMeta());
        }
    }

    @Override
    public TreeTableState getMultiViewState(boolean create) {
        FacesContext fc = this.getFacesContext();
        String viewId = fc.getViewRoot().getViewId();
        return PrimeFaces.current().multiViewState().get(viewId, this.getClientId(fc), create, TreeTableState::new);
    }

    @Override
    public void resetMultiViewState() {
        this.reset();
    }

    public void reset() {
        this.setValue(null);
        this.setFilteredValue(null);
        this.setFirst(0);
        this.setDefaultSort(false);
        this.setDefaultFilter(false);
        this.setSortByAsMap(null);
        this.setFilterByAsMap(null);
    }

    @Override
    public Map<String, SortMeta> getSortByAsMap() {
        return ComponentUtils.computeIfAbsent(this.getStateHelper(), (Serializable)((Object)TreeTableBase.InternalPropertyKeys.sortByAsMap.name()), () -> this.initSortBy(this.getFacesContext()));
    }

    @Override
    public void setSortByAsMap(Map<String, SortMeta> sortBy) {
        this.getStateHelper().put((Serializable)((Object)TreeTableBase.InternalPropertyKeys.sortByAsMap.name()), sortBy);
    }

    @Override
    public Map<String, FilterMeta> getFilterByAsMap() {
        return ComponentUtils.eval(this.getStateHelper(), (Serializable)((Object)TreeTableBase.InternalPropertyKeys.filterByAsMap.name()), () -> this.initFilterBy(this.getFacesContext()));
    }

    @Override
    public void setFilterByAsMap(Map<String, FilterMeta> filterBy) {
        this.getStateHelper().put((Serializable)((Object)TreeTableBase.InternalPropertyKeys.filterByAsMap.name()), filterBy);
    }

    @Override
    public boolean isDefaultSort() {
        return this.getSortByAsMap() != null && Boolean.TRUE.equals(this.getStateHelper().get((Serializable)((Object)TreeTableBase.InternalPropertyKeys.defaultSort.name())));
    }

    @Override
    public void setDefaultSort(boolean defaultSort) {
        this.getStateHelper().put((Serializable)((Object)TreeTableBase.InternalPropertyKeys.defaultSort.name()), (Object)defaultSort);
    }

    @Override
    public boolean isDefaultFilter() {
        return Boolean.TRUE.equals(this.getStateHelper().get((Serializable)((Object)TreeTableBase.InternalPropertyKeys.defaultFilter.name())));
    }

    @Override
    public void setDefaultFilter(boolean defaultFilter) {
        this.getStateHelper().put((Serializable)((Object)TreeTableBase.InternalPropertyKeys.defaultFilter.name()), (Object)defaultFilter);
    }

    @Override
    public boolean isFilterByAsMapDefined() {
        return this.getStateHelper().get((Serializable)((Object)TreeTableBase.InternalPropertyKeys.filterByAsMap.name())) != null;
    }

    public boolean isMultiSort() {
        return "multiple".equals(this.getSortMode());
    }

    @Override
    public Map<String, ColumnMeta> getColumnMeta() {
        HashMap<String, ColumnMeta> value = (HashMap<String, ColumnMeta>)this.getStateHelper().get((Serializable)((Object)TreeTableBase.InternalPropertyKeys.columnMeta));
        if (value == null) {
            value = new HashMap<String, ColumnMeta>();
            this.setColumnMeta(value);
        }
        return value;
    }

    @Override
    public void setColumnMeta(Map<String, ColumnMeta> columnMeta) {
        this.getStateHelper().put((Serializable)((Object)TreeTableBase.InternalPropertyKeys.columnMeta), columnMeta);
    }

    @Override
    public String getWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)TreeTableBase.InternalPropertyKeys.width), null);
    }

    @Override
    public void setWidth(String width) {
        this.getStateHelper().put((Serializable)((Object)TreeTableBase.InternalPropertyKeys.width), (Object)width);
    }

    @Override
    public void filterAndSort() {
        this.setValue(null);
        TreeTableFeatures.filterFeature().filter(FacesContext.getCurrentInstance(), this, this.getValue());
        TreeTableFeatures.sortFeature().sort(FacesContext.getCurrentInstance(), this);
    }

    public boolean shouldEncodeFeature(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_encodeFeature");
    }
}

