/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.export;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.export.ExporterUtils;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.export.TreeTableExporter;
import org.primefaces.util.EscapeUtils;

public class TreeTableXMLExporter
extends TreeTableExporter<PrintWriter, ExporterOptions> {
    public TreeTableXMLExporter() {
        super(null, Collections.emptySet(), false);
    }

    @Override
    protected PrintWriter createDocument(FacesContext context) throws IOException {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(this.os(), this.exportConfiguration.getEncodingType());
            return new PrintWriter(osw);
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    @Override
    protected void exportTable(FacesContext context, TreeTable table, int index) throws IOException {
        String doctag = table.getExportTag() != null ? table.getExportTag() : table.getId();
        ((PrintWriter)this.document).append("<?xml version=\"1.0\"?>\n").append("<").append(doctag).append(">\n");
        super.exportTable(context, table, index);
        ((PrintWriter)this.document).append("</").append(doctag).append(">");
    }

    @Override
    protected void preRowExport(FacesContext context, TreeTable table) {
        String rowtag = table.getExportRowTag() != null ? table.getExportRowTag() : table.getVar();
        ((PrintWriter)this.document).append("\t<").append(rowtag).append(">\n");
    }

    @Override
    protected void postRowExport(FacesContext context, TreeTable table) {
        String rowtag = table.getExportRowTag() != null ? table.getExportRowTag() : table.getVar();
        ((PrintWriter)this.document).append("\t</").append(rowtag).append(">\n");
        super.postRowExport(context, table);
    }

    @Override
    protected void postExport(FacesContext context) throws IOException {
        super.postExport(context);
        if (this.document != null) {
            ((PrintWriter)this.document).flush();
        }
    }

    @Override
    protected void exportCellValue(FacesContext context, TreeTable table, UIColumn col, String text, int index) {
        String tag = ExporterUtils.getColumnExportTag(context, col);
        ((PrintWriter)this.document).append("\t\t<").append(tag).append(">").append(EscapeUtils.forXml(text)).append("</").append(tag).append(">\n");
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public String getFileExtension() {
        return ".xml";
    }
}

