/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.config;

import java.util.Map;
import java.util.Objects;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.config.WebXmlParser;
import org.primefaces.util.LangUtils;

public class PrimeConfiguration {
    private final boolean validateEmptyFields;
    private final boolean partialSubmitEnabled;
    private final boolean resetValuesEnabled;
    private final boolean interpretEmptyStringAsNull;
    private final String theme;
    private final boolean primeIconsEnabled;
    private final boolean clientSideLocalizationEnabled;
    private final boolean clientSideValidationEnabled;
    private final String uploader;
    private final boolean transformMetadataEnabled;
    private final boolean legacyWidgetNamespace;
    private final boolean interpolateClientSideValidationMessages;
    private final boolean earlyPostParamEvaluation;
    private final boolean moveScriptsToBottom;
    private final boolean html5Compliance;
    private boolean csp;
    private boolean policyProvided;
    private String cspPolicy;
    private String cspReportOnlyPolicy;
    private String[] exceptionTypesToIgnoreInLogging;
    private final String multiViewStateStore;
    private final boolean markInputAsInvalidOnErrorMsg;
    private final boolean stringConverterAvailable;
    private final boolean beanValidationEnabled;
    private final Map<String, String> errorPages;
    private boolean cookiesSecure;
    private String cookiesSameSite;

    public PrimeConfiguration(FacesContext context, PrimeEnvironment environment) {
        ServletContext se;
        ExternalContext externalContext = context.getExternalContext();
        this.stringConverterAvailable = null != context.getApplication().createConverter(String.class);
        this.errorPages = WebXmlParser.getErrorPages(context);
        this.validateEmptyFields = this.resolveValidateEmptyFields(context, environment);
        String value = externalContext.getInitParameter("javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL");
        this.interpretEmptyStringAsNull = Boolean.parseBoolean(value);
        value = externalContext.getInitParameter("primefaces.SUBMIT");
        this.partialSubmitEnabled = "partial".equalsIgnoreCase(value);
        value = externalContext.getInitParameter("primefaces.RESET_VALUES");
        this.resetValuesEnabled = Boolean.parseBoolean(value);
        value = externalContext.getInitParameter("primefaces.CLIENT_SIDE_VALIDATION");
        this.clientSideValidationEnabled = Boolean.parseBoolean(value);
        value = externalContext.getInitParameter("primefaces.UPLOADER");
        this.uploader = value == null ? "auto" : value;
        this.theme = externalContext.getInitParameter("primefaces.THEME");
        value = externalContext.getInitParameter("primefaces.PRIME_ICONS");
        this.primeIconsEnabled = Boolean.parseBoolean(Objects.toString(value, "true"));
        value = externalContext.getInitParameter("primefaces.TRANSFORM_METADATA");
        this.transformMetadataEnabled = Boolean.parseBoolean(value);
        value = externalContext.getInitParameter("primefaces.LEGACY_WIDGET_NAMESPACE");
        this.legacyWidgetNamespace = Boolean.parseBoolean(value);
        value = externalContext.getInitParameter("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR");
        this.beanValidationEnabled = environment.isBeanValidationAvailable() && !Boolean.parseBoolean(value);
        value = externalContext.getInitParameter("primefaces.INTERPOLATE_CLIENT_SIDE_VALIDATION_MESSAGES");
        this.interpolateClientSideValidationMessages = Boolean.parseBoolean(value);
        value = externalContext.getInitParameter("primefaces.EARLY_POST_PARAM_EVALUATION");
        this.earlyPostParamEvaluation = Boolean.parseBoolean(value);
        value = externalContext.getInitParameter("primefaces.CLIENT_SIDE_LOCALISATION");
        this.clientSideLocalizationEnabled = Boolean.parseBoolean(value);
        value = externalContext.getInitParameter("primefaces.MOVE_SCRIPTS_TO_BOTTOM");
        this.moveScriptsToBottom = Boolean.parseBoolean(value);
        value = externalContext.getInitParameter("primefaces.HTML5_COMPLIANCE");
        this.html5Compliance = Boolean.parseBoolean(value);
        switch (value = Objects.toString(externalContext.getInitParameter("primefaces.CSP"))) {
            case "true": {
                this.csp = Boolean.TRUE;
                this.cspPolicy = externalContext.getInitParameter("primefaces.CSP_POLICY");
                break;
            }
            case "reportOnly": {
                this.csp = Boolean.TRUE;
                this.cspReportOnlyPolicy = externalContext.getInitParameter("primefaces.CSP_REPORT_ONLY_POLICY");
                break;
            }
            case "policyProvided": {
                this.csp = Boolean.TRUE;
                this.policyProvided = Boolean.TRUE;
                break;
            }
            default: {
                this.csp = Boolean.FALSE;
            }
        }
        value = externalContext.getInitParameter("primefaces.EXCEPTION_TYPES_TO_IGNORE_IN_LOGGING");
        this.exceptionTypesToIgnoreInLogging = LangUtils.isBlank(value) ? new String[0] : value.split(",");
        this.multiViewStateStore = externalContext.getInitParameter("primefaces.MULTI_VIEW_STATE_STORE");
        value = externalContext.getInitParameter("primefaces.MARK_INPUT_AS_INVALID_ON_ERROR_MSG");
        this.markInputAsInvalidOnErrorMsg = Boolean.parseBoolean(value);
        if (environment.isAtLeastJsf40()) {
            value = externalContext.getInitParameter("primefaces.COOKIES_SAME_SITE");
            this.cookiesSameSite = value == null ? "Strict" : value;
        }
        this.cookiesSecure = true;
        if (environment.isAtLeastServlet30() && externalContext.getContext() instanceof ServletContext && (se = (ServletContext)externalContext.getContext()).getSessionCookieConfig() != null) {
            this.cookiesSecure = se.getSessionCookieConfig().isSecure();
        }
    }

    protected boolean resolveValidateEmptyFields(FacesContext context, PrimeEnvironment environment) {
        ExternalContext externalContext = context.getExternalContext();
        String param = externalContext.getInitParameter("javax.faces.VALIDATE_EMPTY_FIELDS");
        if (param == null && externalContext.getApplicationMap().containsKey("javax.faces.VALIDATE_EMPTY_FIELDS")) {
            Object applicationMapValue = externalContext.getApplicationMap().get("javax.faces.VALIDATE_EMPTY_FIELDS");
            if (applicationMapValue instanceof String) {
                param = (String)applicationMapValue;
            } else if (applicationMapValue instanceof Boolean) {
                return (Boolean)applicationMapValue;
            }
        }
        param = param == null ? "auto" : param.toLowerCase();
        return "auto".equals(param) && environment.isBeanValidationAvailable() || "true".equals(param);
    }

    public boolean isValidateEmptyFields() {
        return this.validateEmptyFields;
    }

    public boolean isPartialSubmitEnabled() {
        return this.partialSubmitEnabled;
    }

    public boolean isResetValuesEnabled() {
        return this.resetValuesEnabled;
    }

    public boolean isInterpretEmptyStringAsNull() {
        return this.interpretEmptyStringAsNull;
    }

    public String getTheme() {
        return this.theme;
    }

    public boolean isPrimeIconsEnabled() {
        return this.primeIconsEnabled;
    }

    public boolean isClientSideLocalizationEnabled() {
        return this.clientSideLocalizationEnabled;
    }

    public boolean isClientSideValidationEnabled() {
        return this.clientSideValidationEnabled;
    }

    public String getUploader() {
        return this.uploader;
    }

    public boolean isTransformMetadataEnabled() {
        return this.transformMetadataEnabled;
    }

    public boolean isLegacyWidgetNamespace() {
        return this.legacyWidgetNamespace;
    }

    public boolean isInterpolateClientSideValidationMessages() {
        return this.interpolateClientSideValidationMessages;
    }

    public boolean isEarlyPostParamEvaluation() {
        return this.earlyPostParamEvaluation;
    }

    public boolean isMoveScriptsToBottom() {
        return this.moveScriptsToBottom;
    }

    public boolean isHtml5Compliant() {
        return this.html5Compliance;
    }

    public boolean isStringConverterAvailable() {
        return this.stringConverterAvailable;
    }

    public boolean isBeanValidationEnabled() {
        return this.beanValidationEnabled;
    }

    public Map<String, String> getErrorPages() {
        return this.errorPages;
    }

    public boolean isCsp() {
        return this.csp;
    }

    public boolean isPolicyProvided() {
        return this.policyProvided;
    }

    public String getCspPolicy() {
        return this.cspPolicy;
    }

    public String getCspReportOnlyPolicy() {
        return this.cspReportOnlyPolicy;
    }

    public String[] getExceptionTypesToIgnoreInLogging() {
        return this.exceptionTypesToIgnoreInLogging;
    }

    public String getMultiViewStateStore() {
        return this.multiViewStateStore;
    }

    public boolean isMarkInputAsInvalidOnErrorMsg() {
        return this.markInputAsInvalidOnErrorMsg;
    }

    public boolean isCookiesSecure() {
        return this.cookiesSecure;
    }

    public String getCookiesSameSite() {
        return this.cookiesSameSite;
    }
}

