/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.metadata.transformer;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.metadata.transformer.MetadataTransformer;
import org.primefaces.metadata.transformer.impl.BeanValidationInputMetadataTransformer;

public class MetadataTransformerExecutor
implements SystemEventListener {
    private static final MetadataTransformer BV_INPUT_METADATA_TRANSFORMER = new BeanValidationInputMetadataTransformer();

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        try {
            if (event instanceof PreRenderComponentEvent) {
                PreRenderComponentEvent preRenderComponentEvent = (PreRenderComponentEvent)event;
                MetadataTransformerExecutor.execute(PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()), preRenderComponentEvent.getComponent());
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIComponent;
    }

    public static void execute(PrimeApplicationContext applicationContext, UIComponent component) throws IOException {
        if (applicationContext.getConfig().isTransformMetadataEnabled()) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (applicationContext.getConfig().isBeanValidationEnabled()) {
                BV_INPUT_METADATA_TRANSFORMER.transform(context, applicationContext, component);
            }
            if (!applicationContext.getMetadataTransformers().isEmpty()) {
                for (int i = 0; i < applicationContext.getMetadataTransformers().size(); ++i) {
                    applicationContext.getMetadataTransformers().get(i).transform(context, applicationContext, component);
                }
            }
        }
    }

    public static void registerMetadataTransformer(MetadataTransformer metadataTransformer) {
        PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getMetadataTransformers().add(metadataTransformer);
    }

    public static MetadataTransformer removeMetadataTransformer(Class<? extends MetadataTransformer> clazz) {
        Iterator<MetadataTransformer> iterator = PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getMetadataTransformers().iterator();
        while (iterator.hasNext()) {
            MetadataTransformer metadataTransformer = iterator.next();
            if (!metadataTransformer.getClass().equals(clazz)) continue;
            iterator.remove();
            return metadataTransformer;
        }
        return null;
    }
}

