/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.behavior.confirm.ConfirmBehavior;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.api.ClientBehaviorRenderingMode;
import org.primefaces.component.api.DialogReturnAware;
import org.primefaces.component.api.MenuItemAware;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.component.divider.Divider;
import org.primefaces.component.menuitem.UIMenuItem;
import org.primefaces.event.MenuActionEvent;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuGroup;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.Separator;
import org.primefaces.renderkit.OutcomeTargetRenderer;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.LangUtils;

public class MenuItemAwareRenderer
extends OutcomeTargetRenderer {
    private static final Logger LOGGER = Logger.getLogger(MenuItemAwareRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        this.decodeDynamicMenuItem(context, component);
    }

    protected void encodeOnClick(FacesContext context, UIComponent source, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.setConfirmationScript(context, menuitem);
        String onclick = menuitem.getOnclick();
        boolean isLink = LangUtils.isNotBlank(menuitem.getUrl()) || LangUtils.isNotBlank(menuitem.getOutcome());
        boolean isCommand = LangUtils.isNotBlank(menuitem.getCommand());
        if (!isCommand && menuitem instanceof UIMenuItem) {
            UIMenuItem uim = (UIMenuItem)menuitem;
            boolean bl = isCommand = uim.getActionExpression() != null || uim.getActionListeners().length > 0;
        }
        if (isLink) {
            String targetURL = this.getTargetURL(context, (UIOutcomeTarget)((Object)menuitem));
            writer.writeAttribute("href", (Object)targetURL, null);
            if (menuitem.getTarget() != null) {
                writer.writeAttribute("target", (Object)menuitem.getTarget(), null);
            }
        } else {
            writer.writeAttribute("href", (Object)"javascript:void(0)", null);
        }
        if (isCommand) {
            String command;
            String menuClientId = source.getClientId(context);
            UIForm form = ComponentTraversalUtils.closestForm(source);
            if (form == null) {
                LOGGER.log(Level.FINE, () -> "Menu '" + menuClientId + "' should be inside a form or should reference a form via its form attribute. We will try to find a fallback form on the client side.");
            }
            if (menuitem.isDynamic()) {
                Map<String, List<String>> params = menuitem.getParams();
                if (params == null) {
                    params = new LinkedHashMap<String, List<String>>();
                }
                params.put(menuClientId + "_menuid", Collections.singletonList(menuitem.getId()));
                command = menuitem.isAjax() ? this.buildAjaxRequest(context, source, (AjaxSource)((Object)menuitem), form, params) : this.buildNonAjaxRequest(context, source, (UIComponent)form, menuClientId, params, true);
            } else {
                String string = command = menuitem.isAjax() ? this.buildAjaxRequest(context, (UIComponent)((AjaxSource)((Object)menuitem)), form) : this.buildNonAjaxRequest(context, (UIComponent)menuitem, (UIComponent)form, ((UIComponent)menuitem).getClientId(context), true);
            }
            if (isLink) {
                command = "if(PF.metaKey(event)){return true};" + command;
            }
            String string = onclick = onclick == null ? command : onclick + ";" + command;
        }
        if (onclick != null) {
            if (menuitem.requiresConfirmation()) {
                writer.writeAttribute("data-pfconfirmcommand", (Object)onclick, null);
                writer.writeAttribute("onclick", (Object)menuitem.getConfirmationScript(), "onclick");
            } else {
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
        }
        if (menuitem instanceof DialogReturnAware) {
            ArrayList<ClientBehaviorContext.Parameter> behaviorParams = new ArrayList<ClientBehaviorContext.Parameter>(1);
            behaviorParams.add(new ClientBehaviorContext.Parameter("CLIENT_BEHAVIOR_RENDERING_MODE", (Object)ClientBehaviorRenderingMode.UNOBSTRUSIVE));
            String dialogReturnBehavior = this.getEventBehaviors(context, (ClientBehaviorHolder)menuitem, "dialogReturn", behaviorParams);
            if (dialogReturnBehavior != null) {
                writer.writeAttribute("data-dialogreturn", (Object)dialogReturnBehavior, null);
            }
        }
    }

    protected void encodeSeparator(FacesContext context, Separator separator) throws IOException {
        String styleClass;
        if (!separator.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        if (separator instanceof Divider) {
            String layout = ((Divider)separator).getLayout();
            String align = ((Divider)separator).getAlign();
            String type = ((Divider)separator).getType();
            boolean isHorizontal = "horizontal".equals(layout);
            boolean isVertical = "vertical".equals(layout);
            styleClass = this.getStyleClassBuilder(context).add("ui-divider ui-widget").add(separator.getStyleClass()).add(isHorizontal, "ui-divider-horizontal").add(isVertical, "ui-divider-vertical").add("solid".equals(type), "ui-divider-solid").add("dashed".equals(type), "ui-divider-dashed").add("dotted".equals(type), "ui-divider-dotted").add(isHorizontal && (align == null || "left".equals(align)), "ui-divider-left").add(isHorizontal && "right".equals(align), "ui-divider-right").add(isHorizontal && "center".equals(align) || isVertical && (align == null || "center".equals(align)), "ui-divider-center").add(isVertical && "top".equals(align), "ui-divider-top").add(isVertical && "bottom".equals(align), "ui-divider-bottom").build();
        } else {
            styleClass = this.getStyleClassBuilder(context).add("ui-divider ui-widget").add("ui-divider-horizontal").add("ui-divider-solid").add(separator.getStyleClass()).build();
        }
        writer.startElement("li", null);
        writer.writeAttribute("role", (Object)"separator", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.endElement("li");
    }

    protected void setConfirmationScript(FacesContext context, MenuItem item) {
        if (item instanceof ClientBehaviorHolder) {
            List clickBehaviors;
            Map behaviors = ((ClientBehaviorHolder)item).getClientBehaviors();
            List list = clickBehaviors = behaviors == null ? null : (List)behaviors.get("click");
            if (clickBehaviors != null && !clickBehaviors.isEmpty()) {
                for (int i = 0; i < clickBehaviors.size(); ++i) {
                    ClientBehavior clientBehavior = (ClientBehavior)clickBehaviors.get(i);
                    if (!(clientBehavior instanceof ConfirmBehavior)) continue;
                    ClientBehaviorContext cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)item), (String)"click", (String)item.getClientId(), Collections.emptyList());
                    clientBehavior.getScript(cbc);
                    break;
                }
            }
        }
    }

    protected MenuItem findMenuItemById(List<MenuElement> elements, String id) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        for (int i = 0; i < elements.size(); ++i) {
            MenuItem result;
            MenuElement element = elements.get(i);
            String menuId = element.getId();
            if (menuId != null) {
                menuId = menuId.split(Pattern.quote("|"))[0];
            }
            if (Objects.equals(menuId, id)) {
                return (MenuItem)element;
            }
            if (!(element instanceof MenuGroup) || (result = this.findMenuItemById(((MenuGroup)element).getElements(), id)) == null) continue;
            return result;
        }
        return null;
    }

    protected MenuItem findMenuItemByCoordinates(List<MenuElement> elements, String coords) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        String[] paths = coords.split("_");
        if (paths.length == 0) {
            return null;
        }
        int childIndex = Integer.parseInt(paths[0]);
        if (childIndex >= elements.size()) {
            return null;
        }
        MenuElement childElement = elements.get(childIndex);
        if (paths.length == 1) {
            return (MenuItem)childElement;
        }
        String relativeIndex = coords.substring(coords.indexOf("_") + 1);
        return this.findMenuItemByCoordinates(((MenuGroup)childElement).getElements(), relativeIndex);
    }

    protected boolean decodeDynamicMenuItem(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String menuid = (String)params.get(clientId + "_menuid");
        if (menuid == null) {
            return false;
        }
        String[] ids = menuid.split(Pattern.quote("|"));
        if (ids.length == 0) {
            return false;
        }
        String uuid = ids[0];
        String coordinates = ids.length == 2 ? ids[1] : null;
        MenuItem menuitem = this.findMenuItemById(((MenuItemAware)component).getElements(), uuid);
        if (menuitem == null && coordinates != null) {
            menuitem = this.findMenuItemByCoordinates(((MenuItemAware)component).getElements(), coordinates);
        }
        if (menuitem != null && !menuitem.isDisabled()) {
            MenuActionEvent event = new MenuActionEvent(component, menuitem);
            if (menuitem.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            component.queueEvent((FacesEvent)event);
        }
        return true;
    }
}

