/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.factory;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.context.ResponseWriterWrapper;
import java.io.IOException;

public class Html5FacesContextResponseWriter
extends ResponseWriterWrapper {
    private static final String SCRIPT = "script";
    private boolean inScriptStartTag;

    public Html5FacesContextResponseWriter(ResponseWriter wrapped) {
        super(wrapped);
    }

    public void startElement(String name, UIComponent component) throws IOException {
        super.startElement(name, component);
        this.inScriptStartTag = SCRIPT.equalsIgnoreCase(name);
    }

    public void endElement(String name) throws IOException {
        super.endElement(name);
        if (SCRIPT.equalsIgnoreCase(name)) {
            this.inScriptStartTag = false;
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.inScriptStartTag && "text/javascript".equals(value)) {
            return;
        }
        super.writeAttribute(name, value, property);
    }
}

