/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceWrapper;
import jakarta.faces.context.FacesContext;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;

public class PrimeResource
extends ResourceWrapper {
    private Resource wrapped;
    private String version;

    public PrimeResource(Resource resource) {
        this.wrapped = resource;
        FacesContext context = FacesContext.getCurrentInstance();
        this.version = PrimeRequestContext.getCurrentInstance(context).isHideResourceVersion() ? null : "&v=" + PrimeApplicationContext.getCurrentInstance(context).getEnvironment().getBuildVersion();
    }

    public Resource getWrapped() {
        return this.wrapped;
    }

    public String getRequestPath() {
        if (this.version == null) {
            return super.getRequestPath();
        }
        return super.getRequestPath() + this.version;
    }

    public String getContentType() {
        return this.getWrapped().getContentType();
    }

    public String getLibraryName() {
        return this.getWrapped().getLibraryName();
    }

    public String getResourceName() {
        return this.getWrapped().getResourceName();
    }

    public void setContentType(String contentType) {
        this.getWrapped().setContentType(contentType);
    }

    public void setLibraryName(String libraryName) {
        this.getWrapped().setLibraryName(libraryName);
    }

    public void setResourceName(String resourceName) {
        this.getWrapped().setResourceName(resourceName);
    }

    public String toString() {
        return this.getWrapped().toString();
    }
}

