/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.Map;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.api.TouchAware;
import org.primefaces.component.api.UIData;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.util.MessageFactory;

public class UIPageableData
extends UIData
implements Pageable,
TouchAware {
    public static final String PAGINATOR_TOP_CONTAINER_CLASS = "ui-paginator ui-paginator-top ui-widget-header";
    public static final String PAGINATOR_BOTTOM_CONTAINER_CLASS = "ui-paginator ui-paginator-bottom ui-widget-header";
    public static final String PAGINATOR_PAGES_CLASS = "ui-paginator-pages";
    public static final String PAGINATOR_TOP_LEFT_CONTENT_CLASS = "ui-paginator-top-left-content";
    public static final String PAGINATOR_TOP_RIGHT_CONTENT_CLASS = "ui-paginator-top-right-content";
    public static final String PAGINATOR_BOTTOM_LEFT_CONTENT_CLASS = "ui-paginator-bottom-left-content";
    public static final String PAGINATOR_BOTTOM_RIGHT_CONTENT_CLASS = "ui-paginator-bottom-right-content";
    public static final String PAGINATOR_PAGE_CLASS = "ui-paginator-page ui-state-default ui-corner-all";
    public static final String PAGINATOR_ACTIVE_PAGE_CLASS = "ui-paginator-page ui-state-default ui-state-active ui-corner-all";
    public static final String PAGINATOR_CURRENT_CLASS = "ui-paginator-current";
    public static final String PAGINATOR_RPP_OPTIONS_CLASS = "ui-paginator-rpp-options ui-widget ui-state-default ui-corner-left";
    public static final String PAGINATOR_RPP_LABEL_CLASS = "ui-paginator-rpp-label ui-helper-hidden";
    public static final String PAGINATOR_JTP_SELECT_CLASS = "ui-paginator-jtp-select ui-widget ui-state-default ui-corner-left";
    public static final String PAGINATOR_JTP_INPUT_CLASS = "ui-paginator-jtp-input ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
    public static final String PAGINATOR_FIRST_PAGE_LINK_CLASS = "ui-paginator-first ui-state-default ui-corner-all";
    public static final String PAGINATOR_FIRST_PAGE_ICON_CLASS = "ui-icon ui-icon-seek-first";
    public static final String PAGINATOR_PREV_PAGE_LINK_CLASS = "ui-paginator-prev ui-state-default ui-corner-all";
    public static final String PAGINATOR_PREV_PAGE_ICON_CLASS = "ui-icon ui-icon-seek-prev";
    public static final String PAGINATOR_NEXT_PAGE_LINK_CLASS = "ui-paginator-next ui-state-default ui-corner-all";
    public static final String PAGINATOR_NEXT_PAGE_ICON_CLASS = "ui-icon ui-icon-seek-next";
    public static final String PAGINATOR_LAST_PAGE_LINK_CLASS = "ui-paginator-last ui-state-default ui-corner-all";
    public static final String PAGINATOR_LAST_PAGE_ICON_CLASS = "ui-icon ui-icon-seek-end";
    public static final String ARIA_HEADER_LABEL = "primefaces.paginator.aria.HEADER";
    public static final String ARIA_FIRST_PAGE_LABEL = "primefaces.paginator.aria.FIRST_PAGE";
    public static final String ARIA_PREVIOUS_PAGE_LABEL = "primefaces.paginator.aria.PREVIOUS_PAGE";
    public static final String ARIA_NEXT_PAGE_LABEL = "primefaces.paginator.aria.NEXT_PAGE";
    public static final String ARIA_LAST_PAGE_LABEL = "primefaces.paginator.aria.LAST_PAGE";
    public static final String ROWS_PER_PAGE_LABEL = "primefaces.paginator.aria.ROWS_PER_PAGE";
    public static final String EMPTY_MESSAGE = "primefaces.data.EMPTY_MESSAGE";

    public String getEmptyMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), (Object)MessageFactory.getMessage(EMPTY_MESSAGE, new Object[0]));
    }

    public void setEmptyMessage(String emptyMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)emptyMessage);
    }

    @Override
    public Boolean isTouchable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.touchable));
    }

    @Override
    public void setTouchable(Boolean touchable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.touchable), (Object)touchable);
    }

    public boolean isPaginator() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginator), (Object)false);
    }

    public void setPaginator(boolean paginator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginator), (Object)paginator);
    }

    @Override
    public String getPaginatorTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginatorTemplate), (Object)"{FirstPageLink} {PreviousPageLink} {PageLinks} {NextPageLink} {LastPageLink} {RowsPerPageDropdown}");
    }

    public void setPaginatorTemplate(String paginatorTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginatorTemplate), (Object)paginatorTemplate);
    }

    @Override
    public String getRowsPerPageTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowsPerPageTemplate), null);
    }

    public void setRowsPerPageTemplate(String rowsPerPageTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowsPerPageTemplate), (Object)rowsPerPageTemplate);
    }

    @Override
    public String getRowsPerPageLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowsPerPageLabel), null);
    }

    public void setRowsPerPageLabel(String rowsPerPageLabel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowsPerPageLabel), (Object)rowsPerPageLabel);
    }

    @Override
    public String getCurrentPageReportTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currentPageReportTemplate), (Object)"({currentPage} of {totalPages})");
    }

    public void setCurrentPageReportTemplate(String currentPageReportTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.currentPageReportTemplate), (Object)currentPageReportTemplate);
    }

    @Override
    public int getPageLinks() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pageLinks), (Object)10);
    }

    public void setPageLinks(int pageLinks) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.pageLinks), (Object)pageLinks);
    }

    @Override
    public String getPaginatorPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginatorPosition), (Object)"both");
    }

    public void setPaginatorPosition(String paginatorPosition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginatorPosition), (Object)paginatorPosition);
    }

    @Override
    public boolean isPaginatorAlwaysVisible() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginatorAlwaysVisible), (Object)true);
    }

    public void setPaginatorAlwaysVisible(boolean paginatorAlwaysVisible) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginatorAlwaysVisible), (Object)paginatorAlwaysVisible);
    }

    @Override
    public int getRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rows), (Object)0);
    }

    public void setRows(int rows) {
        ValueExpression rowsVe;
        int rowsOld;
        if (this.getStateHelper().eval((Serializable)((Object)InternalPropertyKeys.rowsInitialValue)) == null && (rowsOld = this.getRows()) != 0) {
            this.getStateHelper().put((Serializable)((Object)InternalPropertyKeys.rowsInitialValue), (Object)rowsOld);
        }
        if (rows < 0) {
            throw new IllegalArgumentException(String.valueOf(rows));
        }
        ELContext elContext = this.getFacesContext().getELContext();
        if (this.isWriteable(elContext, rowsVe = ValueExpressionAnalyzer.getExpression(elContext, this.getValueExpression(PropertyKeys.rows.name()), true))) {
            rowsVe.setValue(elContext, (Object)rows);
        } else {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.rows), (Object)rows);
        }
    }

    public void setFirst(int first) {
        ValueExpression firstVe;
        ELContext elContext = this.getFacesContext().getELContext();
        if (this.isWriteable(elContext, firstVe = ValueExpressionAnalyzer.getExpression(elContext, this.getValueExpression("first"), true))) {
            firstVe.setValue(elContext, (Object)first);
        } else {
            super.setFirst(first);
        }
    }

    public void resetRows() {
        ELContext elContext = this.getFacesContext().getELContext();
        ValueExpression rowsVe = ValueExpressionAnalyzer.getExpression(elContext, this.getValueExpression(PropertyKeys.rows.name()), true);
        if (rowsVe != null) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.rows));
        } else {
            Object rows = this.getStateHelper().eval((Serializable)((Object)InternalPropertyKeys.rowsInitialValue));
            if (rows != null) {
                this.setRows((Integer)rows);
            }
        }
    }

    private boolean isWriteable(ELContext elContext, ValueExpression ve) {
        return ve != null && !ve.isReadOnly(elContext);
    }

    public void calculateRows() {
        if ("*".equals(this.getRowsPerPage())) {
            this.setRows(this.getRowCount());
        }
    }

    public boolean calculateFirst() {
        int rows = this.getRows();
        if (rows > 0) {
            int first = this.getFirst();
            int rowCount = this.getRowCount();
            if (rowCount > 0 && first >= rowCount) {
                int numberOfPages = (int)Math.ceil((double)rowCount * 1.0 / (double)rows);
                int newFirst = Math.max((numberOfPages - 1) * rows, 0);
                this.setFirst(newFirst);
                return first != newFirst;
            }
        }
        return false;
    }

    @Override
    public int getPage() {
        if (this.getRowCount() > 0) {
            int rows = this.getRowsToRender();
            if (rows > 0) {
                int first = this.getFirst();
                return first / rows;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int getPageCount() {
        return (int)Math.ceil((double)this.getRowCount() * 1.0 / (double)this.getRowsToRender());
    }

    @Override
    public int getRowsToRender() {
        int rows = this.getRows();
        return rows == 0 ? this.getRowCount() : rows;
    }

    public boolean isPaginationRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_pagination");
    }

    private boolean isRowsPerPageValid(String rowsParam) {
        if (rowsParam == null) {
            return true;
        }
        String rowsPerPageTemplate = this.getRowsPerPageTemplate();
        if (rowsPerPageTemplate != null) {
            String[] options;
            for (String option : options = rowsPerPageTemplate.split("[,]+")) {
                String opt = option.trim();
                if (!opt.equals(rowsParam) && (!opt.startsWith("{ShowAll|") || !"*".equals(rowsParam))) continue;
                return true;
            }
            return false;
        }
        int rows = this.getRows();
        if (rows > 0) {
            return Integer.toString(rows).equals(rowsParam);
        }
        return true;
    }

    public void updatePaginationData(FacesContext context) {
        this.setRowIndex(-1);
        String clientId = this.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String firstParam = (String)params.get(clientId + "_first");
        String rowsParam = (String)params.get(clientId + "_rows");
        if (!this.isRowsPerPageValid(rowsParam)) {
            throw new IllegalArgumentException("Unsupported rows per page value: " + rowsParam);
        }
        this.setFirst(Integer.parseInt(firstParam));
        int newRowsValue = "*".equals(rowsParam) ? this.getRowCount() : Integer.parseInt(rowsParam);
        this.setRows(newRowsValue);
        this.setRowsPerPage(rowsParam);
    }

    public String getRowsPerPage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)"rowsPerPage"), null);
    }

    public void setRowsPerPage(String rowsPerPage) {
        this.getStateHelper().put((Serializable)((Object)"rowsPerPage"), (Object)rowsPerPage);
    }

    public static enum PropertyKeys {
        rows,
        touchable,
        paginator,
        paginatorTemplate,
        rowsPerPageTemplate,
        rowsPerPageLabel,
        currentPageReportTemplate,
        pageLinks,
        paginatorPosition,
        paginatorAlwaysVisible,
        emptyMessage;

    }

    protected static enum InternalPropertyKeys {
        rowsInitialValue;

    }
}

