/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.barcode;

import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.primefaces.application.resource.DynamicContentType;
import org.primefaces.component.barcode.Barcode;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;
import org.primefaces.util.SharedStringBuilder;

public class BarcodeRenderer
extends CoreRenderer {
    private static final String SB_BUILD = BarcodeRenderer.class.getName() + "#build";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DynamicContentType dynamicContentType;
        ResponseWriter writer = context.getResponseWriter();
        Barcode barcode = (Barcode)component;
        String clientId = barcode.getClientId(context);
        String styleClass = barcode.getStyleClass();
        String src = null;
        Object value = barcode.getValue();
        String type = barcode.getType();
        DynamicContentType dynamicContentType2 = dynamicContentType = "qr".equals(type) ? DynamicContentType.QR_CODE : DynamicContentType.BARCODE;
        if (value == null) {
            return;
        }
        try {
            Resource resource = context.getApplication().getResourceHandler().createResource("dynamiccontent.properties", "primefaces", "image/png");
            String resourcePath = resource.getRequestPath();
            String sessionKey = UUID.randomUUID().toString();
            Map session = context.getExternalContext().getSessionMap();
            HashMap<String, String> barcodeMapping = (HashMap<String, String>)session.get("primefaces.barcodeMapping");
            if (barcodeMapping == null) {
                barcodeMapping = new HashMap<String, String>();
                session.put("primefaces.barcodeMapping", barcodeMapping);
            }
            barcodeMapping.put(sessionKey, (String)value);
            StringBuilder builder = SharedStringBuilder.get(context, SB_BUILD);
            src = builder.append(resourcePath).append("&").append("pfdrid").append("=").append(URLEncoder.encode(sessionKey, "UTF-8")).append("&").append("pfdrt").append("=").append(dynamicContentType.toString()).append("&gen=").append(type).append("&fmt=").append(barcode.getFormat()).append("&qrec=").append(barcode.getQrErrorCorrection()).append("&hrp=").append(barcode.getHrp()).append("&").append("pfdrid_c").append("=").append(barcode.isCache()).append("&ori=").append(barcode.getOrientation()).toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException(ex);
        }
        writer.startElement("img", (UIComponent)barcode);
        if (this.shouldWriteId(component)) {
            writer.writeAttribute("id", (Object)clientId, "id");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.writeAttribute("src", (Object)context.getExternalContext().encodeResourceURL(src), null);
        this.renderPassThruAttributes(context, (UIComponent)barcode, HTML.IMG_ATTRS);
        writer.endElement("img");
    }
}

