/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.primefaces.component.api.UICalendar;
import org.primefaces.component.calendar.CalendarBase;
import org.primefaces.event.DateViewChangeEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="inputmask/inputmask.js"), @ResourceDependency(library="primefaces", name="calendar/calendar.css"), @ResourceDependency(library="primefaces", name="calendar/calendar.js")})
public class Calendar
extends CalendarBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Calendar";
    private Map<String, AjaxBehaviorEvent> customEvents = new HashMap<String, AjaxBehaviorEvent>(1);

    public boolean isPopup() {
        return this.getMode().equalsIgnoreCase("popup");
    }

    @Override
    public Collection<String> getEventNames() {
        return CALENDAR_EVENT_NAMES;
    }

    @Override
    public Collection<String> getUnobstrusiveEventNames() {
        return UNOBSTRUSIVE_EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("jakarta.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName != null) {
                if ("dateSelect".equals(eventName) || "close".equals(eventName)) {
                    this.customEvents.put(eventName, (AjaxBehaviorEvent)event);
                } else if ("viewChange".equals(eventName)) {
                    int month = Integer.parseInt((String)params.get(clientId + "_month"));
                    int year = Integer.parseInt((String)params.get(clientId + "_year"));
                    DateViewChangeEvent dateViewChangeEvent = new DateViewChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), month, year);
                    dateViewChangeEvent.setPhaseId(behaviorEvent.getPhaseId());
                    super.queueEvent((FacesEvent)dateViewChangeEvent);
                } else {
                    super.queueEvent(event);
                }
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void validate(FacesContext context) {
        super.validate(context);
        if (this.isValid() && ComponentUtils.isRequestSource((UIComponent)this, context) && this.customEvents != null) {
            for (Map.Entry<String, AjaxBehaviorEvent> event : this.customEvents.entrySet()) {
                SelectEvent<Object> selectEvent = new SelectEvent<Object>((UIComponent)this, event.getValue().getBehavior(), this.getValue());
                if (event.getValue().getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
                    selectEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                } else {
                    selectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
                }
                super.queueEvent(selectEvent);
            }
        }
    }

    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        UICalendar.ValidationResult validationResult = UICalendar.ValidationResult.OK;
        if (this.isValid() && !Calendar.isEmpty((Object)value) && (value instanceof LocalDate || value instanceof LocalDateTime || value instanceof Date)) {
            LocalDate date = null;
            if (value instanceof LocalDate) {
                date = (LocalDate)value;
            } else if (value instanceof LocalDateTime) {
                date = ((LocalDateTime)value).toLocalDate();
            } else if (!(value instanceof LocalTime) && value instanceof Date) {
                date = CalendarUtils.convertDate2LocalDate((Date)value, CalendarUtils.calculateZoneId(this.getTimeZone()));
            }
            if (date != null) {
                LocalDate minDate = CalendarUtils.getObjectAsLocalDate(context, this, this.getMindate());
                LocalDate maxDate = CalendarUtils.getObjectAsLocalDate(context, this, this.getMaxdate());
                if (minDate != null && date.isBefore(minDate)) {
                    this.setValid(false);
                    validationResult = maxDate != null ? UICalendar.ValidationResult.INVALID_OUT_OF_RANGE : UICalendar.ValidationResult.INVALID_MIN_DATE;
                }
                if (this.isValid() && maxDate != null && date.isAfter(maxDate)) {
                    this.setValid(false);
                    validationResult = minDate != null ? UICalendar.ValidationResult.INVALID_OUT_OF_RANGE : UICalendar.ValidationResult.INVALID_MAX_DATE;
                }
            }
            if (!this.isValid()) {
                this.createFacesMessageFromValidationResult(context, validationResult);
            }
        }
    }

    public Object saveState(FacesContext context) {
        if (this.customEvents != null) {
            this.customEvents.clear();
        }
        return super.saveState(context);
    }
}

