/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.column.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.primefaces.component.column.Column;
import org.primefaces.component.column.renderer.HelperColumnRenderer;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.TreeTableRenderer;
import org.primefaces.util.ComponentUtils;

public class ColumnGroupHelperRenderer
implements HelperColumnRenderer {
    @Override
    public void encode(FacesContext context, Column column) throws IOException {
        ColumnGroup group = this.findGroup(column);
        if (group.getParent() instanceof DataTable) {
            this.encodeDataTable(context, (DataTable)group.getParent(), column, group);
        } else if (group.getParent() instanceof TreeTable) {
            this.encodeTreeTable(context, (TreeTable)group.getParent(), column, group);
        } else {
            throw new IllegalArgumentException("ColumnGroupHelperRenderer cannot be used for " + group.getParent().getClass());
        }
    }

    private ColumnGroup findGroup(Column column) {
        UIComponent parent = column.getParent();
        while (!(parent instanceof ColumnGroup)) {
            parent = parent.getParent();
        }
        return (ColumnGroup)parent;
    }

    private void encodeDataTable(FacesContext context, DataTable dataTable, Column column, ColumnGroup group) throws IOException {
        DataTableRenderer renderer = (DataTableRenderer)((Object)ComponentUtils.getUnwrappedRenderer(context, "org.primefaces.component", "org.primefaces.component.DataTableRenderer"));
        String type = group.getType();
        if ("header".equals(type) || "frozenHeader".equals(type) || "scrollableHeader".equals(type)) {
            renderer.encodeColumnHeader(context, dataTable, column);
        } else if ("footer".equals(type) || "frozenFooter".equals(type) || "scrollableFooter".equals(type)) {
            renderer.encodeColumnFooter(context, dataTable, column);
        }
    }

    private void encodeTreeTable(FacesContext context, TreeTable treeTable, Column column, ColumnGroup group) throws IOException {
        TreeTableRenderer renderer = (TreeTableRenderer)((Object)ComponentUtils.getUnwrappedRenderer(context, "org.primefaces.component", "org.primefaces.component.TreeTableRenderer"));
        String type = group.getType();
        if ("header".equals(type)) {
            renderer.encodeColumnHeader(context, treeTable, column);
        } else if ("footer".equals(type)) {
            renderer.encodeColumnFooter(context, treeTable, column);
        }
    }
}

