/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dashboard;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.dashboard.Dashboard;
import org.primefaces.component.panel.Panel;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.model.dashboard.DashboardModel;
import org.primefaces.model.dashboard.DashboardWidget;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.GridLayoutUtils;
import org.primefaces.util.WidgetBuilder;

public class DashboardRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Dashboard dashboard = (Dashboard)component;
        this.encodeMarkup(context, dashboard);
        this.encodeScript(context, dashboard);
    }

    protected void encodeMarkup(FacesContext context, Dashboard dashboard) throws IOException {
        DashboardModel model;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dashboard.getClientId(context);
        boolean responsive = dashboard.isResponsive();
        writer.startElement("div", (UIComponent)dashboard);
        writer.writeAttribute("id", (Object)clientId, "id");
        String styleClass = this.getStyleClassBuilder(context).add("ui-dashboard").add(dashboard.getStyleClass()).add(dashboard.isDisabled(), "ui-state-disabled").add(responsive, GridLayoutUtils.getFlexGridClass(true)).build();
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (dashboard.getStyle() != null) {
            writer.writeAttribute("style", (Object)dashboard.getStyle(), "style");
        }
        if ((model = dashboard.getModel()) != null) {
            List<DashboardWidget> widgets = model.getWidgets();
            for (int i = 0; i < widgets.size(); ++i) {
                DashboardWidget column = widgets.get(i);
                String columnStyle = column.getStyle();
                String columnStyleClass = this.getStyleClassBuilder(context).add(!responsive, "ui-dashboard-column").add(responsive, "ui-dashboard-panel").add(column.getStyleClass()).build();
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)columnStyleClass, null);
                if (columnStyle != null) {
                    writer.writeAttribute("style", (Object)columnStyle, null);
                }
                for (String widgetId : column.getWidgets()) {
                    Panel widget = (Panel)SearchExpressionFacade.resolveComponent(context, (UIComponent)dashboard, widgetId);
                    if (widget == null) continue;
                    this.renderChild(context, (UIComponent)widget);
                }
                writer.endElement("div");
            }
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Dashboard dashboard) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Dashboard", dashboard).attr("responsive", dashboard.isResponsive(), false).attr("disabled", !dashboard.isReordering(), false);
        this.encodeClientBehaviors(context, dashboard);
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

