/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.export;

import jakarta.faces.context.FacesContext;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.export.TableExporter;
import org.primefaces.model.LazyDataModel;

public abstract class DataTableExporter<P, O extends ExporterOptions>
extends TableExporter<DataTable, P, O> {
    private static final int NO_ROW_INDEX_REQUIRED = Integer.MIN_VALUE;

    protected DataTableExporter(O defaultOptions) {
        super(defaultOptions);
    }

    protected DataTableExporter(O defaultOptions, Set<TableExporter.FacetType> supportedFacetTypes, boolean joinComponents) {
        super(defaultOptions, supportedFacetTypes, joinComponents);
    }

    @Override
    protected void exportSelectionOnly(FacesContext context, DataTable table) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportRow(context, table, Integer.MIN_VALUE);
                }
            } else if (Collection.class.isAssignableFrom(selection.getClass())) {
                for (Object obj : (Collection)selection) {
                    requestMap.put(var, obj);
                    this.exportRow(context, table, Integer.MIN_VALUE);
                }
            } else {
                requestMap.put(var, selection);
                this.exportRow(context, table, Integer.MIN_VALUE);
            }
        }
    }

    @Override
    protected void exportPageOnly(FacesContext context, DataTable table) {
        int first = table.getFirst();
        int rows = table.getRows();
        if (rows == 0) {
            rows = table.getRowCount();
        }
        int rowsToExport = first + rows;
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(context, table, rowIndex);
        }
    }

    @Override
    protected void exportAll(FacesContext context, DataTable table) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            LazyDataModel lazyDataModel = (LazyDataModel)table.getValue();
            Object wrappedData = lazyDataModel.getWrappedData();
            if (rowCount > 0) {
                table.setFirst(0);
                table.setRows(rowCount);
                table.loadLazyDataIfEnabled();
            }
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(context, table, rowIndex);
            }
            table.setFirst(first);
            table.setRows(rows);
            table.setRowIndex(-1);
            lazyDataModel.setWrappedData(wrappedData);
            lazyDataModel.setPageSize(rows);
            lazyDataModel.setRowIndex(-1);
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(context, table, rowIndex);
            }
            table.setFirst(first);
        }
    }

    protected void exportRow(FacesContext context, DataTable table, int rowIndex) {
        if (rowIndex != Integer.MIN_VALUE) {
            table.setRowIndex(rowIndex);
            if (!table.isRowAvailable()) {
                return;
            }
        }
        super.addCells(context, table);
    }
}

