/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.primefaces.component.datatable.feature.AddRowFeature;
import org.primefaces.component.datatable.feature.CellEditFeature;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DraggableColumnsFeature;
import org.primefaces.component.datatable.feature.DraggableRowsFeature;
import org.primefaces.component.datatable.feature.FilterFeature;
import org.primefaces.component.datatable.feature.PageFeature;
import org.primefaces.component.datatable.feature.ResizableColumnsFeature;
import org.primefaces.component.datatable.feature.RowEditFeature;
import org.primefaces.component.datatable.feature.RowExpandFeature;
import org.primefaces.component.datatable.feature.ScrollFeature;
import org.primefaces.component.datatable.feature.SelectionFeature;
import org.primefaces.component.datatable.feature.SortFeature;

public class DataTableFeatures {
    private static final Map<Class<? extends DataTableFeature>, DataTableFeature> ALL_FEATURES = Stream.of(new DraggableColumnsFeature(), new FilterFeature(), new PageFeature(), new SortFeature(), new ResizableColumnsFeature(), new SelectionFeature(), new RowEditFeature(), new CellEditFeature(), new RowExpandFeature(), new ScrollFeature(), new DraggableRowsFeature(), new AddRowFeature()).collect(Collectors.toMap(Object::getClass, Function.identity(), (u, v) -> u, LinkedHashMap::new));

    private DataTableFeatures() {
    }

    public static Collection<DataTableFeature> all() {
        return ALL_FEATURES.values();
    }

    public static <T extends DataTableFeature> T get(Class<T> feature) {
        return (T)Optional.ofNullable(ALL_FEATURES.get(feature)).orElseThrow(() -> new UnsupportedOperationException("Feature " + feature.getName() + " not supported"));
    }

    public static <T extends DataTableFeature> T replace(Class<T> original, T feature) {
        if (!original.isAssignableFrom(feature.getClass())) {
            throw new IllegalArgumentException(original.getName() + " is not assignable from " + feature.getClass().getName());
        }
        if (!ALL_FEATURES.containsKey(original)) {
            throw new UnsupportedOperationException("Feature " + original.getName() + " not supported");
        }
        return (T)ALL_FEATURES.replace(original, feature);
    }

    public static SortFeature sortFeature() {
        return DataTableFeatures.get(SortFeature.class);
    }

    public static FilterFeature filterFeature() {
        return DataTableFeatures.get(FilterFeature.class);
    }

    public static SelectionFeature selectionFeature() {
        return DataTableFeatures.get(SelectionFeature.class);
    }

    public static RowExpandFeature rowExpandFeature() {
        return DataTableFeatures.get(RowExpandFeature.class);
    }
}

