/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import jakarta.el.ELContext;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.primefaces.PrimeFaces;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.ColumnBase;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.DataTableState;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatures;
import org.primefaces.event.data.PostFilterEvent;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.FunctionFilterConstraint;
import org.primefaces.util.ComponentUtils;

public class FilterFeature
implements DataTableFeature {
    private boolean isFilterRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_filtering");
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return context.getCurrentPhaseId() == PhaseId.PROCESS_VALIDATIONS && this.isFilterRequest(context, table);
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isFilterRequest(context, table);
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        Map<String, FilterMeta> filterBy = table.getFilterByAsMap();
        table.updateFilterByValuesWithFilterRequest(context, filterBy);
        table.setFirst(0);
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        String rppValue = (String)params.get(clientId + "_rppDD");
        if (rppValue != null && !"*".equals(rppValue)) {
            table.setRows(Integer.parseInt(rppValue));
        }
        if (table.isMultiViewState()) {
            DataTableState ts = table.getMultiViewState(true);
            ts.setFilterBy(filterBy);
            if (table.isPaginator()) {
                ts.setFirst(table.getFirst());
                ts.setRows(table.getRows());
            }
        }
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        if (!table.loadLazyDataIfEnabled()) {
            this.filter(context, table);
            if (table.isSortingCurrentlyActive()) {
                DataTableFeatures.sortFeature().sort(context, table);
            }
        }
        context.getApplication().publishEvent(context, PostFilterEvent.class, (Object)table);
        if (!table.isFullUpdateRequest(context)) {
            renderer.encodeTbody(context, table, true);
        }
    }

    public void filter(FacesContext context, DataTable table) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        Locale filterLocale = table.resolveDataLocale();
        ELContext elContext = context.getELContext();
        Map<String, FilterMeta> filterBy = table.getFilterByAsMap();
        FilterMeta globalFilter = filterBy.get("globalFilter");
        boolean hasGlobalFilterFunction = globalFilter != null && globalFilter.getConstraint() instanceof FunctionFilterConstraint;
        table.setValue(null);
        AtomicBoolean localMatch = new AtomicBoolean();
        AtomicBoolean globalMatch = new AtomicBoolean();
        for (int i = 0; i < table.getRowCount(); ++i) {
            table.setRowIndex(i);
            Object rowData = table.getRowData();
            localMatch.set(true);
            globalMatch.set(false);
            if (hasGlobalFilterFunction) {
                globalMatch.set(globalFilter.getConstraint().isMatching(context, rowData, globalFilter.getFilterValue(), filterLocale));
            }
            int rowIndex = i;
            table.forEachColumn(column -> {
                Object filterValue;
                FilterConstraint constraint;
                FilterMeta filter = (FilterMeta)filterBy.get(column.getColumnKey((UIComponent)table, rowIndex));
                if (filter == null || filter.isGlobalFilter()) {
                    return true;
                }
                Object columnValue = filter.getLocalValue(elContext, (UIColumn)column);
                if (globalFilter != null && globalFilter.isActive() && !globalMatch.get() && !hasGlobalFilterFunction) {
                    constraint = globalFilter.getConstraint();
                    filterValue = globalFilter.getFilterValue();
                    globalMatch.set(constraint.isMatching(context, columnValue, filterValue, filterLocale));
                }
                if (!filter.isActive()) {
                    return true;
                }
                constraint = filter.getConstraint();
                filterValue = filter.getFilterValue();
                if (filterValue instanceof String && column instanceof ColumnBase) {
                    ColumnBase columnBase = (ColumnBase)column;
                    try {
                        filterValue = ComponentUtils.getConvertedValue(context, (UIComponent)columnBase, columnBase.getConverter(), filterValue);
                    }
                    catch (Exception ex) {
                        filterValue = null;
                    }
                }
                localMatch.set(constraint.isMatching(context, columnValue, filterValue, filterLocale));
                return localMatch.get();
            });
            boolean matches = localMatch.get();
            if (globalFilter != null && globalFilter.isActive()) {
                boolean bl = matches = matches && globalMatch.get();
            }
            if (!matches) continue;
            filtered.add(rowData);
        }
        if ((table.isPaginator() || table.isVirtualScroll()) && ComponentUtils.isRequestSource((UIComponent)table, context)) {
            PrimeFaces.current().ajax().addCallbackParam("totalRecords", filtered.size());
        }
        table.setFilteredValue(filtered);
        table.setValue(DataTable.convertIntoObjectValueType(context, table, filtered));
        table.setRowIndex(-1);
    }
}

