/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatures;
import org.primefaces.util.ComponentUtils;
import org.primefaces.visit.ResetInputVisitCallback;

public class RowEditFeature
implements DataTableFeature {
    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        String action;
        if (table.isSelectionEnabled()) {
            DataTableFeatures.selectionFeature().decodeSelectionRowKeys(context, table);
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        int editedRowId = Integer.parseInt((String)params.get(clientId + "_rowEditIndex"));
        table.setRowIndex(editedRowId);
        if (table.isRowEditRequest(context) && "cancel".equals(action = (String)params.get(clientId + "_rowEditAction"))) {
            VisitContext visitContext = null;
            for (UIColumn column : table.getColumns()) {
                for (UIComponent grandkid : column.getChildren()) {
                    if (!(grandkid instanceof CellEditor)) continue;
                    UIComponent inputFacet = grandkid.getFacet("input");
                    if (inputFacet instanceof EditableValueHolder) {
                        ((EditableValueHolder)inputFacet).resetValue();
                        continue;
                    }
                    if (visitContext == null) {
                        visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
                    }
                    inputFacet.visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
                }
            }
        }
        if (table.isRowAvailable()) {
            renderer.encodeRow(context, table, clientId, editedRowId);
        }
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return table.isRowEditRequest(context) || table.isRowEditInitRequest(context);
    }
}

