/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datepicker;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.Locale;
import org.primefaces.component.api.FlexAware;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.api.MixedClientBehaviorHolder;
import org.primefaces.component.api.UICalendar;
import org.primefaces.component.api.Widget;
import org.primefaces.model.datepicker.DateMetadataModel;
import org.primefaces.util.CalendarUtils;

public abstract class DatePickerBase
extends UICalendar
implements Widget,
InputHolder,
MixedClientBehaviorHolder,
FlexAware {
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.component.DatePickerRenderer";
    public static final int RESPONSIVE_BREAKPOINT_SMALL = 576;
    protected String timeSeparator;
    protected String fractionSeparator;

    public DatePickerBase() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getPlaceholder() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.placeholder), null);
    }

    public void setPlaceholder(String placeholder) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.placeholder), (Object)placeholder);
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public boolean isInline() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.inline), (Object)false);
    }

    public void setInline(boolean inline) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.inline), (Object)inline);
    }

    public String getButtonTabindex() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.buttonTabindex), null);
    }

    public void setButtonTabindex(String buttonTabindex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.buttonTabindex), (Object)buttonTabindex);
    }

    public boolean isShowIcon() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showIcon), (Object)false);
    }

    public void setShowIcon(boolean showIcon) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showIcon), (Object)showIcon);
    }

    public String getBeforeShow() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.beforeShow), null);
    }

    public void setBeforeShow(String beforeShow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.beforeShow), (Object)beforeShow);
    }

    public boolean isFocusOnSelect() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.focusOnSelect), (Object)false);
    }

    public void setFocusOnSelect(boolean focusOnSelect) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.focusOnSelect), (Object)focusOnSelect);
    }

    public String getYearRange() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.yearRange), null);
    }

    public void setYearRange(String yearRange) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.yearRange), (Object)yearRange);
    }

    @Override
    public String getSelectionMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectionMode), (Object)"single");
    }

    public void setSelectionMode(String selectionMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectionMode), (Object)selectionMode);
    }

    public boolean isShowOtherMonths() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showOtherMonths), (Object)false);
    }

    public void setShowOtherMonths(boolean showOtherMonths) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showOtherMonths), (Object)showOtherMonths);
    }

    public boolean isSelectOtherMonths() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectOtherMonths), (Object)false);
    }

    public void setSelectOtherMonths(boolean selectOtherMonths) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectOtherMonths), (Object)selectOtherMonths);
    }

    public boolean isShowOnFocus() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showOnFocus), (Object)true);
    }

    public void setShowOnFocus(boolean showOnFocus) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showOnFocus), (Object)showOnFocus);
    }

    public String getShortYearCutoff() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.shortYearCutoff), null);
    }

    public void setShortYearCutoff(String shortYearCutoff) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.shortYearCutoff), (Object)shortYearCutoff);
    }

    public boolean isMonthNavigator() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.monthNavigator), (Object)false);
    }

    public void setMonthNavigator(boolean monthNavigator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.monthNavigator), (Object)monthNavigator);
    }

    public boolean isYearNavigator() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.yearNavigator), (Object)false);
    }

    public void setYearNavigator(boolean yearNavigator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.yearNavigator), (Object)yearNavigator);
    }

    public boolean isShowTime() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showTime), (Object)false);
    }

    public Boolean isShowTimeWithoutDefault() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showTime));
    }

    public void setShowTime(boolean showTime) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showTime), (Object)showTime);
    }

    public String getHourFormat() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.hourFormat), null);
    }

    public void setHourFormat(String hourFormat) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.hourFormat), (Object)hourFormat);
    }

    public boolean isShowSeconds() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showSeconds), (Object)false);
    }

    public Boolean isShowSecondsWithoutDefault() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showSeconds));
    }

    public void setShowSeconds(boolean showSeconds) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showSeconds), (Object)showSeconds);
    }

    public boolean isShowMilliseconds() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showMilliseconds), (Object)false);
    }

    public Boolean isShowMillisecondsWithoutDefault() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showMilliseconds));
    }

    public void setShowMilliseconds(boolean showMilliseconds) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showMilliseconds), (Object)showMilliseconds);
    }

    public int getStepHour() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stepHour), (Object)1);
    }

    public void setStepHour(int stepHour) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stepHour), (Object)stepHour);
    }

    public int getStepMinute() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stepMinute), (Object)1);
    }

    public void setStepMinute(int stepMinute) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stepMinute), (Object)stepMinute);
    }

    public int getStepSecond() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stepSecond), (Object)1);
    }

    public void setStepSecond(int stepSecond) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stepSecond), (Object)stepSecond);
    }

    public int getStepMillisecond() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stepMillisecond), (Object)1);
    }

    public void setStepMillisecond(int stepMillisecond) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stepMillisecond), (Object)stepMillisecond);
    }

    public boolean isShowButtonBar() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showButtonBar), (Object)false);
    }

    public void setShowButtonBar(boolean showButtonBar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showButtonBar), (Object)showButtonBar);
    }

    public String getPanelStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.panelStyleClass), null);
    }

    public void setPanelStyleClass(String panelStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.panelStyleClass), (Object)panelStyleClass);
    }

    public String getPanelStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.panelStyle), null);
    }

    public void setPanelStyle(String panelStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.panelStyle), (Object)panelStyle);
    }

    public boolean isKeepInvalid() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.keepInvalid), (Object)false);
    }

    public void setKeepInvalid(boolean keepInvalid) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.keepInvalid), (Object)keepInvalid);
    }

    public boolean isHideOnDateTimeSelect() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.hideOnDateTimeSelect), (Object)false);
    }

    public void setHideOnDateTimeSelect(boolean hideOnDateTimeSelect) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.hideOnDateTimeSelect), (Object)hideOnDateTimeSelect);
    }

    public int getMaxDateCount() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxDateCount), (Object)Integer.MAX_VALUE);
    }

    public void setMaxDateCount(int maxDateCount) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxDateCount), (Object)maxDateCount);
    }

    public int getNumberOfMonths() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.numberOfMonths), (Object)1);
    }

    public void setNumberOfMonths(int numberOfMonths) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.numberOfMonths), (Object)numberOfMonths);
    }

    public String getView() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.view), null);
    }

    public void setView(String view) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.view), (Object)view);
    }

    public boolean isAutoDetectDisplay() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.autoDetectDisplay), (Object)true);
    }

    public void setAutoDetectDisplay(boolean autoDetectDisplay) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.autoDetectDisplay), (Object)autoDetectDisplay);
    }

    public boolean isTouchUI() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.touchUI), (Object)false);
    }

    public void setTouchUI(boolean touchUI) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.touchUI), (Object)touchUI);
    }

    public String getDateTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dateTemplate), null);
    }

    public void setDateTemplate(String dateTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dateTemplate), (Object)dateTemplate);
    }

    public String getAppendTo() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.appendTo), (Object)"@(body)");
    }

    public void setAppendTo(String appendTo) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.appendTo), (Object)appendTo);
    }

    public String getTriggerButtonIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.triggerButtonIcon), null);
    }

    public void setTriggerButtonIcon(String triggerButtonIcon) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.triggerButtonIcon), (Object)triggerButtonIcon);
    }

    public List getDisabledDates() {
        return (List)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabledDates), null);
    }

    public void setDisabledDates(List disabledDates) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabledDates), (Object)disabledDates);
    }

    public List<Integer> getDisabledDays() {
        return (List)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabledDays), null);
    }

    public void setDisabledDays(List<Integer> disabledDays) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabledDays), disabledDays);
    }

    public String getOnMonthChange() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onMonthChange), null);
    }

    public void setOnMonthChange(String onMonthChange) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onMonthChange), (Object)onMonthChange);
    }

    public String getOnYearChange() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onYearChange), null);
    }

    public void setOnYearChange(String onYearChange) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onYearChange), (Object)onYearChange);
    }

    public boolean isTimeInput() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeInput), (Object)false);
    }

    public void setTimeInput(boolean timeInput) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeInput), (Object)timeInput);
    }

    public boolean isShowWeek() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showWeek), (Object)false);
    }

    public void setShowWeek(boolean showWeek) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showWeek), (Object)showWeek);
    }

    public String getWeekCalculator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.weekCalculator), null);
    }

    public void setWeekCalculator(String weekCalculator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.weekCalculator), (Object)weekCalculator);
    }

    public DateMetadataModel getModel() {
        return (DateMetadataModel)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.model), null);
    }

    public void setModel(DateMetadataModel model) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.model), (Object)model);
    }

    public void setResponsiveBreakpoint(int responsiveBreakpoint) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.responsiveBreakpoint), (Object)responsiveBreakpoint);
    }

    public int getResponsiveBreakpoint() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.responsiveBreakpoint), (Object)576);
    }

    public boolean isShowMinMaxRange() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showMinMaxRange), (Object)true);
    }

    public void setShowMinMaxRange(boolean showMinMaxRange) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showMinMaxRange), (Object)showMinMaxRange);
    }

    public boolean isAutoMonthFormat() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.autoMonthFormat), (Object)true);
    }

    public void setAutoMonthFormat(boolean autoMonthFormat) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.autoMonthFormat), (Object)autoMonthFormat);
    }

    @Override
    public boolean isFlex() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.flex), (Object)false);
    }

    public void setFlex(boolean flex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.flex), (Object)flex);
    }

    @Override
    public boolean hasTime() {
        return this.isShowTime() || this.isTimeOnly();
    }

    @Override
    public String calculatePattern() {
        if (this.isTimeOnly()) {
            return this.calculateTimeOnlyPattern();
        }
        if (this.isShowTime()) {
            return this.calculateWidgetPattern() + " " + this.calculateTimeOnlyPattern();
        }
        return this.calculateWidgetPattern();
    }

    @Override
    public String calculateWidgetPattern() {
        return CalendarUtils.removeTime(super.calculatePattern());
    }

    @Override
    public String calculateTimeOnlyPattern() {
        if (this.timeOnlyPattern == null) {
            String separator = this.getTimeSeparator();
            boolean ampm = "12".equals(this.getHourFormat());
            this.timeOnlyPattern = ampm ? "hh" : "HH";
            this.timeOnlyPattern = this.timeOnlyPattern + separator + "mm";
            if (this.isShowSeconds() || this.isShowMilliseconds()) {
                this.timeOnlyPattern = this.timeOnlyPattern + separator + "ss";
            }
            if (this.isShowMilliseconds()) {
                String fractSeparator = this.getFractionSeparator();
                this.timeOnlyPattern = this.timeOnlyPattern + fractSeparator + "SSS";
            }
            if (ampm) {
                this.timeOnlyPattern = this.timeOnlyPattern + " a";
            }
        }
        return this.timeOnlyPattern;
    }

    public String getTimeSeparator() {
        if (this.timeSeparator == null) {
            Locale locale = this.calculateLocale(this.getFacesContext());
            String localePattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(null, FormatStyle.SHORT, IsoChronology.INSTANCE, locale);
            this.timeSeparator = localePattern.contains(":") ? ":" : ".";
        }
        return this.timeSeparator;
    }

    public String getFractionSeparator() {
        if (this.fractionSeparator == null) {
            Locale locale = this.calculateLocale(this.getFacesContext());
            char ds = ((DecimalFormat)DecimalFormat.getInstance(locale)).getDecimalFormatSymbols().getDecimalSeparator();
            this.fractionSeparator = Character.toString(ds);
        }
        return this.fractionSeparator;
    }

    public static enum PropertyKeys {
        placeholder,
        widgetVar,
        timeOnly,
        inline,
        buttonTabindex,
        showIcon,
        beforeShow,
        focusOnSelect,
        yearRange,
        selectionMode,
        showOtherMonths,
        selectOtherMonths,
        showOnFocus,
        shortYearCutoff,
        monthNavigator,
        yearNavigator,
        showTime,
        hourFormat,
        showSeconds,
        showMilliseconds,
        stepHour,
        stepMinute,
        stepSecond,
        stepMillisecond,
        showButtonBar,
        panelStyleClass,
        panelStyle,
        keepInvalid,
        hideOnDateTimeSelect,
        maxDateCount,
        numberOfMonths,
        view,
        autoDetectDisplay,
        responsiveBreakpoint,
        touchUI,
        dateTemplate,
        appendTo,
        triggerButtonIcon,
        disabledDates,
        disabledDays,
        onMonthChange,
        onYearChange,
        timeInput,
        showWeek,
        weekCalculator,
        showMinMaxRange,
        autoMonthFormat,
        model,
        flex;

    }
}

