/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.effect;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.primefaces.component.effect.Effect;
import org.primefaces.component.effect.EffectBuilder;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class EffectRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Effect effect = (Effect)component;
        String source = component.getParent().getClientId(context);
        String event = effect.getEvent();
        int delay = effect.getDelay();
        UIComponent targetComponent = SearchExpressionFacade.resolveComponent(context, (UIComponent)effect, effect.getFor(), SearchExpressionUtils.SET_PARENT_FALLBACK);
        String target = targetComponent.getClientId(context);
        String animation = this.getEffectBuilder(effect, target).build();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Effect", effect).attr("source", source).attr("event", event).attr("delay", delay).callback("fn", "function()", animation);
        wb.finish();
    }

    private EffectBuilder getEffectBuilder(Effect effect, String effectedComponentClientId) {
        EffectBuilder effectBuilder = new EffectBuilder(effect.getType(), effectedComponentClientId, effect.isQueue());
        for (UIComponent child : effect.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            effectBuilder.withOption(param.getName(), (String)param.getValue());
        }
        effectBuilder.atSpeed(effect.getSpeed());
        return effectBuilder;
    }
}

