/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.component.export.Exporter;
import org.primefaces.context.PrimeApplicationContext;

public final class DataExporters {
    private static final Logger LOGGER = Logger.getLogger(DataExporters.class.getName());

    private DataExporters() {
    }

    public static <T extends UIComponent> Exporter<T> get(Class<T> targetClass, String type) {
        PrimeApplicationContext primeAppContext = PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance());
        Class resolvedTargetClass = primeAppContext.getExporters().keySet().stream().filter(k -> k.isAssignableFrom(targetClass)).findFirst().orElseThrow(() -> new UnsupportedOperationException("Component " + targetClass.getName() + " not supported. Use DataExporters#register()"));
        Map<String, Class<Exporter<?>>> supportedExporters = primeAppContext.getExporters().get(resolvedTargetClass);
        String newType = type.toLowerCase();
        Class<Exporter<?>> exportClass = Optional.ofNullable(supportedExporters.get(newType)).orElseThrow(() -> new UnsupportedOperationException("Exporter for " + targetClass.getName() + " of type '" + newType + "' is not supported. Use DataExporters#register()"));
        try {
            return exportClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static <T extends UIComponent, E extends Exporter<T>> void register(Class<T> targetClass, Class<E> exporter, String type) {
        String newType;
        PrimeApplicationContext primeAppContext = PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance());
        Map supportedExporters = primeAppContext.getExporters().computeIfAbsent(targetClass, o -> new HashMap());
        Class<E> old = supportedExporters.put(newType = type.toLowerCase(), exporter);
        if (old != null) {
            LOGGER.log(Level.INFO, "Exporter {0} of type {1} has been replaced by {2}", new Object[]{old.getName(), newType, exporter.getName()});
        } else {
            LOGGER.log(Level.INFO, "New exporter {0} of type {1} has been registered", new Object[]{exporter.getName(), newType});
        }
    }
}

