/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import jakarta.el.MethodExpression;
import java.io.OutputStream;
import org.primefaces.component.export.ExporterOptions;

public class ExportConfiguration {
    private boolean pageOnly;
    private boolean selectionOnly;
    private boolean visibleOnly;
    private boolean exportHeader;
    private boolean exportFooter;
    private String encodingType;
    private MethodExpression preProcessor;
    private MethodExpression postProcessor;
    private ExporterOptions options;
    private MethodExpression onTableRender;
    private MethodExpression onRowExport;
    private OutputStream outputStream;

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ExportConfiguration{pageOnly=" + this.pageOnly + ", selectionOnly=" + this.selectionOnly + ", visibleOnly=" + this.visibleOnly + ", exportHeader=" + this.exportHeader + ", exportFooter=" + this.exportFooter + ", encodingType='" + this.encodingType + '\'' + ", preProcessor=" + this.preProcessor + ", postProcessor=" + this.postProcessor + ", options=" + this.options + ", onTableRender=" + this.onTableRender + ", onRowExport=" + this.onRowExport + ", outputStream=" + this.outputStream + '}';
    }

    public boolean isPageOnly() {
        return this.pageOnly;
    }

    public boolean isSelectionOnly() {
        return this.selectionOnly;
    }

    public boolean isVisibleOnly() {
        return this.visibleOnly;
    }

    public boolean isExportHeader() {
        return this.exportHeader;
    }

    public boolean isExportFooter() {
        return this.exportFooter;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public MethodExpression getPreProcessor() {
        return this.preProcessor;
    }

    public MethodExpression getPostProcessor() {
        return this.postProcessor;
    }

    public ExporterOptions getOptions() {
        return this.options;
    }

    public MethodExpression getOnTableRender() {
        return this.onTableRender;
    }

    public MethodExpression getOnRowExport() {
        return this.onRowExport;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public static class Builder {
        private final ExportConfiguration config = new ExportConfiguration();

        Builder() {
        }

        public Builder pageOnly(boolean pageOnly) {
            this.config.pageOnly = pageOnly;
            return this;
        }

        public Builder selectionOnly(boolean selectionOnly) {
            this.config.selectionOnly = selectionOnly;
            return this;
        }

        public Builder visibleOnly(boolean visibleOnly) {
            this.config.visibleOnly = visibleOnly;
            return this;
        }

        public Builder exportHeader(boolean exportHeader) {
            this.config.exportHeader = exportHeader;
            return this;
        }

        public Builder exportFooter(boolean exportFooter) {
            this.config.exportFooter = exportFooter;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.config.encodingType = encodingType;
            return this;
        }

        public Builder preProcessor(MethodExpression preProcessor) {
            this.config.preProcessor = preProcessor;
            return this;
        }

        public Builder postProcessor(MethodExpression postProcessor) {
            this.config.postProcessor = postProcessor;
            return this;
        }

        public Builder options(ExporterOptions options) {
            this.config.options = options;
            return this;
        }

        public Builder onTableRender(MethodExpression onTableRender) {
            this.config.onTableRender = onTableRender;
            return this;
        }

        public Builder onRowExport(MethodExpression onRowExport) {
            this.config.onRowExport = onRowExport;
            return this;
        }

        public Builder outputStream(OutputStream os) {
            this.config.outputStream = os;
            return this;
        }

        public ExportConfiguration build() {
            return this.config;
        }
    }
}

