/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import jakarta.faces.FacesException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.model.file.UploadedFile;

public interface FileUploadChunkDecoder<T extends HttpServletRequest> {
    public static final String MULTIPARTS = "org.primefaces.file.multiParts";

    default public String generateFileInfoKey(T request) {
        String fileInfo = request.getParameter("X-File-Id");
        if (fileInfo == null) {
            throw new FacesException("Missing X-File-Id header");
        }
        return String.valueOf(fileInfo.hashCode());
    }

    default public String getUploadDirectory(T request) {
        File tmpDir = (File)request.getServletContext().getAttribute("jakarta.servlet.context.tempdir");
        if (tmpDir == null) {
            tmpDir = new File(System.getenv("java.io.tmpdir"));
        }
        return tmpDir.getAbsolutePath();
    }

    public void decodeContentRange(FileUpload var1, T var2, UploadedFile var3) throws IOException;

    public long decodeUploadedBytes(T var1);

    public void deleteChunks(T var1) throws IOException;
}

